<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Invoice</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
  <style>
  body {
    font-family: 'Segoe UI', sans-serif;
    background-color: #f8f9fa;
    margin: 0;
    padding: 30px;
  }

  .invoice-container {
    background-color: #ffffff;
    max-width: 900px;
    margin: auto;
    padding: 30px;
    border-radius: 10px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.08);
  }

  .header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 2px solid #0d6efd;
    padding-bottom: 15px;
    margin-bottom: 20px;
  }

  .logo {
    max-width: 150px;
  }

  .invoice-title {
    text-align: right;
  }

  .section-box {
    background-color: #f1f1f1;
    padding: 20px;
    border-radius: 8px;
    margin-bottom: 20px;
  }

  .section-box h5 {
    margin-bottom: 10px;
    font-weight: bold;
  }

  .table {
    margin-top: 20px;
  }

  .table thead {
    background-color: #0d6efd;
    color: white;
  }

  .total-section {
    text-align: right;
    margin-top: 30px;
  }

  .total-section h4 {
    font-weight: bold;
  }

  .form-control {
    display: inline-block;
    width: auto;
    margin-left: 10px;
  }

  .btn-success {
    margin-top: 20px;
    width: 100%;
    padding: 10px;
    font-size: 16px;
  }
  </style>
</head>

<body>
  <form action="{{ route('invoice.store', ['quotationId' => $quotation->id]) }}" method="POST">
    @csrf
    <div class="invoice-container">
      <div class="header">
        <img src="{{ URL('images/atjoin_logo.png') }}" class="logo" />
        <div class="invoice-title">
          <h2 class="text-primary">INVOICE</h2>
          <p><strong>Invoice No:</strong> {{ $invoiceNumber }}</p>
        </div>
      </div>

      <div class="row mb-4">
        <div class="col-md-6">
          <div class="section-box h-100">
            <h5>From</h5>
            <p>
              <strong>ATJOIN PVT. LTD.</strong><br />
              5th Floor, Luv-Kush Apt., Seasons Business Center,<br />
              Opp. Kothari Hyundai Showroom, Sanewadi, Aundh,<br />
              Pune, Maharashtra 411007, India<br />
              <strong>GST No:</strong> 27AAWCA2027J1ZE
            </p>
          </div>
        </div>

        <div class="col-md-6">
          <div class="section-box h-100">
            <h5>Bill To</h5>
            <p>
              <strong>Company:</strong> {{ $quotation->company_name }}<br />
              <strong>Customer:</strong> {{ $quotation->customer_name }}<br />
              <strong>Address:</strong> {{ $quotation->address }}<br />
              <strong>Contact:</strong> {{ $quotation->contact }}<br />
              <strong>Email:</strong> {{ $quotation->email }}<br />
              <strong>GST No:</strong> {{ $quotation->gst_number }}
            </p>
          </div>
        </div>
      </div>







      <div class="d-flex justify-content-between mb-3">
        <div><strong>Invoice Date:</strong> {{ $invoiceDate }}</div>
        <div><strong>Terms:</strong> Due on Receipt</div>
      </div>

      <table class="table table-bordered table-striped">
        <thead>
          <tr>
            <th>Description</th>
            <th>Qty</th>
            <th>Amount (₹)</th>
            <th>Total (₹)</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($quotationitems as $item)
          <tr>
            <td>{{ $item->description }}</td>
            <td>{{ $item->quantity }}</td>
            <td>₹ {{ number_format($item->amount, 2) }}</td>
            <td>₹ {{ number_format($item->total_amount, 2) }}</td>
          </tr>
          @endforeach
        </tbody>
      </table>

      <div class="total-section">
        <h4>Subtotal: ₹ {{ number_format($quotation->subtotal, 2) }}</h4>

        <input type="hidden" id="hiddenGrandTotal" value="{{ $quotation->grand_total }}">
        <input type="hidden" id="hiddenBalanceDue" name="balance_due" value="{{ $quotation->grand_total }}">

        <label for="discount"><strong>Discount (₹):</strong></label>
        <input type="number" id="discount" name="discount" class="form-control" oninput="updateBalanceDue()" value="0"
          min="0" />

        <h4 class="mt-3">Balance Due: ₹ <span id="balanceDue">{{ number_format($quotation->grand_total, 2) }}</span>
        </h4>
      </div>

      <button type="submit" class="btn btn-success w-25">Generate Invoice</button>
    </div>
  </form>

  <script>
  function updateBalanceDue() {
    let grandTotal = parseFloat(document.getElementById("hiddenGrandTotal").value) || 0;
    let discount = parseFloat(document.getElementById("discount").value) || 0;
    let balanceDue = grandTotal - discount;
    document.getElementById("balanceDue").innerText = "₹ " + balanceDue.toFixed(2);
    document.getElementById("hiddenBalanceDue").value = balanceDue.toFixed(2);
  }
  </script>
</body>

</html>