<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Quotation</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet"
    integrity="sha384-EVSTQN3/azprG1Anm3QDgpJLIm9Nao0Yz1ztcQTwFspd3yD65VohhpuuCOmLASjC" crossorigin="anonymous">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"
    integrity="sha384-MrcW6ZMFYlzcLA8Nl+NtUVF0sA7MsXsP1UyJoMp4YLEuNSfAP+JcXn/tWtIaxVXM" crossorigin="anonymous">
  </script>

  <style>
  body {
    font-family: Arial, sans-serif;
    background-color: #f8f9fa;
    display: flex;
    padding: 20px;
  }

  .sidebar {
    width: 250px;
    background: linear-gradient(135deg, #2c3e50, #2a5298);
    padding: 20px;
    color: white;
    height: 100%;
    position: fixed;
    left: 0;
    top: 0;
  }

  .sidebar img {
    width: 100px;
    height: auto;
    margin-bottom: 20px;
  }

  .sidebar a {
    display: block;
    color: white;
    text-decoration: none;
    padding: 10px;
    margin: 10px 0;
    border-radius: 5px;
    transition: 0.3s;
  }

  .sidebar a:hover {
    background-color: rgb(63, 125, 206);
  }

  .logout-btn {
    background-color: #dc3545;
    color: white;
    font-weight: bold;
    border-radius: 5px;
    padding: 10px;
    text-decoration: none;
    display: inline-block;
    width: 100%;
    text-align: center;
  }

  .logout-btn:hover {
    background-color: #c82333;
    color: white;
  }





  /* Main Content */

  .content {
    margin-top: 30px;
    margin-left: 240px;
    padding: 20px;
    width: 100%;
    text-align: center;
  }

  .quotation-box {
    background: #fff;
    padding: 20px;
    border-radius: 8px;
    box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);

    margin-left: 240px;
    padding: 20px;
    width: 100%;
    /* text-align: center; */
  }

  .header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-bottom: 2px solid #6a0dad;
    padding-bottom: 10px;
  }

  .header h2 {
    color: #6a0dad;
  }

  .header img {
    max-width: 120px;
    margin-bottom: 10px;
  }

  .quotation-details,
  .company-details {
    margin-top: 20px;
  }

  .table th {
    background-color: rgb(206, 206, 206);
    color: black;
  }


  .total-section {
    text-align: right;
    font-weight: bold;
  }



  @media (max-width: 768px) {
    .sidebar {
      width: 200px;
    }


    .footer {
      margin-top: 20px;
      font-size: 14px;
    }
  }


  .small-blue-btn:hover {
    background-color: #0056b3;
    /* Darker blue on hover */
  }
  </style>
</head>

<body>

  <div class="sidebar">
    <img src="{{ URL('images/atjoin_logo.png') }}" alt="Company Logo">
    <h3>Dashboard</h3>
    <a href="{{ route('home.index') }}">🏠 Home</a>
    <a href="{{route('quotationlist.index')}}">📜 Quotation List</a>
    <a href="{{ route('customer') }}" class="text-white">
      <i class="fas fa-user"></i> Customer Master
    </a>

  </div>


  <div class="container quotation-box">
    <div class="header">
      <h2>Quotation</h2>
      <img src="{{ URL('images/atjoin_logo.png') }}" alt="Company Logo">
    </div>

    <form action="{{ route('quotations.store') }}" method="POST">
      @csrf
      <div class="row quotation-details">
        <div class="col-md-6">
          <p><strong>Quotation No:</strong> {{ $quotation->quotation_number }}</p>


        </div>
        <div class="col-md-6 text-end">

          <p><strong>Date:</strong> {{ $quotation->quotation_date }}</p>

        </div>
      </div>

      <div class="row company-details">
        <div class="col-md-6">
          <h5>Quotation By:</h5>
          <p>ATJOIN PVT.LTD<br>5th Floor, Luv-Kush Apt.<br>Seasons Business Center,<br>Opposite Kothari Hyundai
            Showroom,<br>Sanewadi, Aundh <br>Pune, Maharashtra 411007</p>
          <p><strong>GST No:</strong>27AAWCA2027J1ZE </p>
          <p><strong>Place of Supply:</strong>Pune</p>
        </div>
        <div class="col-md-6 text-end">
          <h5>Quotation To:</h5>

          @php
          $selectedCustomer = App\Models\SelectCustomer::first();
          @endphp
          @if($selectedCustomer)

          <p><strong>Company Name:</strong> {{ $selectedCustomer->company_name }}</p>
          <p><strong>Customer Name:</strong> {{ $selectedCustomer->customer_name }}</p>
          <p><strong>Contact:</strong> {{ $selectedCustomer->contact }}</p>
          <p><strong>GST Number:</strong> {{ $selectedCustomer->gst_number }}</p>
          <p><strong>Email:</strong> {{ $selectedCustomer->email }}</p>
          <p><strong>Address:</strong> {{ $selectedCustomer->address }}</p>
          <p><strong>City:</strong> {{ $selectedCustomer->city }}</p>
          @endif

        </div>
      </div>
      <table class="table table-bordered mt-3">
        <thead>
          <tr>
            <th>Item Description</th>
            <th>Qty</th>
            <th>Amount</th>
            <th>Total Amount</th>
          </tr>
        </thead>
        <tbody>
          @if(isset($selectedRows) && count($selectedRows) > 0)
          @foreach($selectedRows as $row)
          <tr>
            <td><input type="text" name="description[]" class="form-control" value="{{ $row['description'] ?? '' }}"
                readonly></td>
            <td><input type="number" name="quantity[]" class="form-control" value="{{ $row['quantity'] ?? '' }}"
                readonly>
            </td>
            <td><input type="text" name="amount[]" class="form-control" value="{{ $row['amount'] ?? '' }}" readonly>
            </td>
            <td><input type="text" name="total_amount[]" class="form-control" value="{{ $row['total_amount'] ?? '' }}"
                readonly></td>
          </tr>
          @endforeach
          @else
          <tr>
            <td colspan="4" class="text-center">No data selected.</td>
          </tr>
          @endif

        </tbody>
      </table>


      <div class="text-end">
        <p><strong>Sub Total:</strong> ₹{{ number_format($subtotal, 2) }}</p>
        <p><strong>CGST :</strong> ₹{{ number_format($cgst, 2) }}</p>
        <p><strong>SGST :</strong> ₹{{  number_format($sgst, 2) }}</p>
        <p><strong>Grand Total:</strong> ₹{{ number_format($grand_total, 2) }}</p>
      </div>

      <table class="table table-bordered mt-3">
        <tr>
          <th>HSN/SAC</th>
          <th>Taxable Value</th>
          <th colspan="2">CGST</th>
          <th colspan="2">SGST</th>
          <th>Total Tax Amount</th>
        </tr>
        <tr>

          <!-- Manually Inserted -->
          <th></th>
          <th></th>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <th></th>
        </tr>
        <tr>
          <td><input type="text" name="hsn_number" class="form-control text-center"></td>
          <!-- Manually Inserted -->
          <td>₹{{ number_format($gst_rate, 2) }}</td>
          <td>{{ $gst_rate / 2 }}%</td>
          <td>₹{{ number_format($cgst, 2) }}</td>
          <td>{{ $gst_rate / 2 }}%</td>
          <td>₹{{ number_format($sgst, 2) }}</td>
          <td>₹{{ number_format($cgst + $sgst, 2) }}</td>
        </tr>
        <tr>
          <td><strong>Total:</strong></td>
          <td><strong>₹{{ number_format($gst_rate, 2) }}</strong></td>
          <td><strong>{{ $gst_rate / 2 }}%</strong></td>
          <td><strong>₹{{ number_format($cgst, 2) }}</strong></td>
          <td><strong>{{ $gst_rate / 2 }}%</strong></td>
          <td><strong>₹{{ number_format($sgst, 2) }}</strong></td>
          <td><strong>₹{{ number_format($cgst + $sgst, 2) }}</strong></td>
        </tr>
      </table>

      <div class="footer">
        <h5>Terms and Conditions</h5>
        <ul>
          <li>Payment due within 15 days of invoice date.</li>
          <li>Overdue interest at 18% will be charged on delayed payments.</li>
        </ul>
        <h5>Additional Notes</h5>
        <p>This quotation is valid for 30 days from the date of issue.</p>
        <p>This quotation is {{$gst_type}}</p>
      </div>


      <div class="w-50">
        <button type="submit" class="btn btn-primary">Save</button>

      </div>


    </form>
  </div>
  </div>


</body>

</html>