<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Item;
use App\Models\Subitem;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Session;

class ItemController extends Controller
{
    public function index() {

      
        return view('items');
    }

    public function store(Request $request)
    {
        // dd($request->all());

     
      $selectedRows = [];
      $subtotal = 0;

      $gst_type = $request->input('gst_type', 'exclusive'); // Default to 'exclusive' or any valid type
      $gst_rate = (float) $request->input('gst_rate', 0);
     
    
    // Store manual data (if provided)
    if ($request->has('manual_data')) {
    $manual = $request->manual_data;
    if (!empty($manual['description']) && !empty($manual['quantity']) && !empty($manual['amount']) &&
    !empty($manual['total_amount'])) {
    Item::create([
    'description' => $manual['description'],
    'quantity' => $manual['quantity'],
    'amount' => $manual['amount'],
    'total_amount' => $manual['total_amount'],
    ]);
    $selectedRows[] = $manual; // Add manual data to the array

    $subtotal += $manual['total_amount']; 
    }
    }
    
     // Store data from uploaded Excel
     if ($request->has('data')) {
      foreach ($request->data as $data) {
          Item::create([
              'description' => $data['description'],
              'quantity' => $data['quantity'],
              'amount' => $data['amount'],
              'total_amount' => $data['total_amount'],
          ]);
          $selectedRows[] = $data;

          $subtotal += $data['total_amount']; 
      }
    
       // GST Calculation
       $gstRate = (float) $request->gst_option;
       $gstTotal = ($subtotal * $gst_rate) / 100;
    
       $cgst = $gstTotal / 2;
     
       $sgst = $gstTotal / 2;
       $grandTotal = $subtotal + $gstTotal;
    

  


    // Store selected data in session
    Session::put('selected_rows', $selectedRows);
   
    
    Subitem::create([
      'subtotal' => $subtotal,
      'cgst' => $cgst,
      'sgst' => $sgst,
      'grand_total' => $grandTotal,
      'gst_rate' => $gst_rate,
      'gst_type' => $gst_type,
  ]);
    
    return redirect()->route('quotations.create')->with('success', ' data stored successfully!');
    }
    }

}