<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customer;

class CustomerController extends Controller
{
    public function index()
    {
        $customers = Customer::all();
       

        return view('customer', compact('customers'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'company_name' => 'nullable|string|max:255',
            'customer_name' => ['required', 'regex:/^[A-Z][a-zA-Z\s]*$/','unique:customers,contact'],
            'contact' => 'required|string|max:10',
            'gst_number' => 'nullable|string',
            'email' => 'required|string|unique:customers,email',
            'address' => 'required|string',
            'city' => 'required|string',
        ]);

         // Store customer data in the database
         Customer::create([
            'company_name' => $request->company_name,
            'customer_name' => $request->customer_name,
            'contact' => $request->contact,
            'gst_number' => $request->gst_number,
            'email' => $request->email,
            'address' => $request->address,
            'city' => $request->city,
        ]);

          // Redirect with a success message
          return redirect()->route('customer')->with('success', 'Customer added successfully!');
    }
}