<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Quotation; // Import the Quotation model
use App\Models\QuotationItem;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use NumberToWords\NumberToWords;
use App\Helpers\NumberToWordHelper;
use Illuminate\Pagination\Paginator;
class QuotationListController extends Controller
{
    
    public function index()
    {
        // Fetch all quotations from the database
        $quotations = Quotation::paginate(10);
       $quotationitems = QuotationItem::all();
       
        return view('quotation_list', compact('quotations','quotationitems'));
    }

    public function edit($id)
    { //dd($id);
        $quotation = Quotation::with('items')->findOrFail($id);
        $quotationitems = QuotationItem::where('quotation_id', $id)->get();
          // Fetch quotation items
    
       
        return view('quotationlist.edit', compact('quotation','quotationitems'));
    }
    
    public function update(Request $request, $id)
{
    $quotation = Quotation::findOrFail($id);

     // Find the quotation and include quotation items
     $quotation = Quotation::with('items')->findOrFail($id);
     

    $quotation->update($request->only([
        'quotation_number', 'quotation_date', 'customer_name', 'gst_rate', 'subtotal', 'cgst', 'sgst', 'grand_total'
    ]));

     // Ensure quotation items exist before calling pluck()
     $existingItemIds = $quotation->items ? $quotation->items->pluck('id')->toArray() : [];

     // Get the updated item IDs from the request
     $updatedItemIds = collect($request->items)->pluck('id')->filter()->toArray();
 
     // Find items that are removed (present in database but not in request)
     $itemsToDelete = array_diff($existingItemIds, $updatedItemIds);
 
     // Delete removed items from the database
     QuotationItem::whereIn('id', $itemsToDelete)->delete();

      // Calculate subtotal (sum of total_amount from all items)
    $subtotal = collect($request->items)->sum(function ($item) {
        return $item['quantity'] * $item['price'];
    });
    
      // Define GST rate (9% each for CGST & SGST)
      $gst_rate = $quotation->gst_rate / 100;
      $cgst = $subtotal * ($gst_rate/2);
      $sgst = $subtotal * ($gst_rate/2);

      // Calculate grand total
      $grand_total = $subtotal + $cgst + $sgst;
       // Update Quotation Details
       $quotation->update([
        'quotation_number' => $request->quotation_number,
        'quotation_date' => $request->quotation_date,
        'customer_name' => $request->customer_name,
        'gst_rate' => $request->gst_rate,
        'subtotal' => $subtotal,
        'cgst' => $cgst,
        'sgst' => $sgst,
        'grand_total' => $grand_total,
    ]);
      
    foreach ($request->items as $index => $item) {
        if (isset($item['id']) && !empty($item['id'])) {
            QuotationItem::where('id', $item['id'])->update([
                'sr_no' =>$index + 1,
                'description' => $item['description'],
                'quantity' => $item['quantity'],
                'amount' => $item['price'],
                'total_amount' => $item['total']
            ]);
        } else {
            QuotationItem::create([
                'quotation_id' => $quotation->id,
                'sr_no' => $index + 1,
                'description' => $item['description'],
                'quantity' => $item['quantity'],
                'amount' => $item['price'],
                'total_amount' => $item['total']
            ]);
        }
    }

       // Update quotation
       $quotation->update([
        'quotation_number' => $request->quotation_number,
        'quotation_date' => $request->quotation_date,
        'customer_name' => $request->customer_name,
        'gst_rate' => $request->gst_rate,
        'subtotal' => $subtotal,
        'cgst' => $cgst,
        'sgst' => $sgst,
        'grand_total' => $grand_total,
    ]);

    

    return redirect()->route('quotationlist.index')->with('success', 'Quotation updated successfully');
}
public function delete($id)
{
    $quotation = Quotation::findOrFail($id);
    $quotation->delete();

    return redirect()->route('quotationlist.index')->with('success', 'Quotation deleted successfully');
}

public function destroy($id)
{
    $quotation = Quotation::findOrFail($id);

    // Delete associated quotation items first
    QuotationItem::where('quotation_id', $quotation->id)->delete();

    // Then delete the quotation
    $quotation->delete();

    return redirect()->route('quotationlist.index')->with('success', 'Quotation deleted successfully.');
}


public function downloadPdf($id)
{
    // Fetch quotation details along with items
    $quotation = Quotation::with('items')->findOrFail($id);
    $quotationitems = QuotationItem::where('quotation_id', $id)->get();
    $quotation->grand_total_in_words = $this->convertToIndianWords($quotation->grand_total);
    // Load the PDF view and pass data
    $pdf = PDF::loadView('quotationlist.pdf', compact('quotation','quotationitems'));
   
    // Return the generated PDF
    return $pdf->download('Quotation-' . $quotation->quotation_number . '.pdf');
}

public static function convertToIndianWords($number)
{
    $words = [
        '0' => '', '1' => 'One', '2' => 'Two', '3' => 'Three',
        '4' => 'Four', '5' => 'Five', '6' => 'Six', '7' => 'Seven',
        '8' => 'Eight', '9' => 'Nine', '10' => 'Ten',
        '11' => 'Eleven', '12' => 'Twelve', '13' => 'Thirteen',
        '14' => 'Fourteen', '15' => 'Fifteen', '16' => 'Sixteen',
        '17' => 'Seventeen', '18' => 'Eighteen', '19' => 'Nineteen',
        '20' => 'Twenty', '30' => 'Thirty', '40' => 'Fourty',
        '50' => 'Fifty', '60' => 'Sixty', '70' => 'Seventy',
        '80' => 'Eighty', '90' => 'Ninety'
    ];

    $digits = ['', 'Hundred', 'Thousand', 'Lakh', 'Crore'];
    $number = round($number);
    $str = [];

    $i = 0;
    while ($number > 0) {
        if ($i == 1) {
            $divider = 10;
        } else {
            $divider = 100;
        }

        $numberPart = $number % $divider;
        $number = floor($number / $divider);

        if ($numberPart) {
            $plural = (($counter = count($str)) && $numberPart > 9) ? 's' : null;
            $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
            if ($numberPart < 21) {
                $word = $words[$numberPart];
            } else {
                $word = $words[floor($numberPart / 10) * 10] . " " . $words[$numberPart % 10];
            }

            $str[] = $word . " " . $digits[$i];
        }
        $i++;
    }

    return implode(' ', array_reverse($str));
}

}