<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Register</title>
  <style>
  body {
    font-family: Arial, sans-serif;
    background-color: #f4f4f4;
    display: flex;
    justify-content: center;
    align-items: center;
    height: 100vh;
    margin: 0;
  }

  .container {
    background: #ffffff;
    padding: 25px;
    border-radius: 10px;
    box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.1);
    width: 350px;
    text-align: center;
  }

  h2 {
    color: #333;
    margin-bottom: 20px;
  }

  .message {
    color: green;
    font-size: 14px;
    margin-bottom: 10px;
  }

  form {
    display: flex;
    flex-direction: column;
    gap: 10px;
  }

  label {
    font-size: 14px;
    color: #555;
    text-align: left;
  }

  input {
    padding: 10px;
    border: 1px solid #ccc;
    border-radius: 5px;
    font-size: 14px;
    width: 100%;
  }

  button {
    background: #28a745;
    color: white;
    border: none;
    padding: 10px;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
  }

  button:hover {
    background: #218838;
  }

  .login-link {
    margin-top: 10px;
    font-size: 14px;
  }

  .login-link a {
    color: #007bff;
    text-decoration: none;
  }

  .login-link a:hover {
    text-decoration: underline;
  }
  </style>
</head>

<body>
  <div class="container">
    <h2>Register</h2>

    <?php if(session('success')): ?>
    <p class="message"><?php echo e(session('success')); ?></p>
    <?php endif; ?>

    <form method="POST" action="<?php echo e(route('register')); ?>">
      <?php echo csrf_field(); ?>
      <label for="name">Name</label>
      <input type="text" id="name" name="name" required>

      <label for="email">Email</label>
      <input type="email" id="email" name="email" required>

      <label for="password">Password</label>
      <input type="password" id="password" name="password" required>

      <button type="submit">Register</button>
    </form>

    <p class="login-link">Already have an account? <a href="<?php echo e(route('login')); ?>">Login</a></p>
  </div>
</body>

</html><?php /**PATH D:\xampp\htdocs\quotation-builder\resources\views\auth\register.blade.php ENDPATH**/ ?>