<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Quotation</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
</head>

<body class="bg-light">

  <div class="d-flex">
    <div class="p-4 text-white  vh-100%" style="width: 250px;  background: linear-gradient(135deg, #2c3e50, #2a5298);">
      <div class="text-center mb-4">
        <img src="{{ URL('images/atjoin_logo.png') }}" alt="Logo" class="img-fluid" style="max-width: 100px;">
      </div>
      <h5>Dashboard</h5>
      <a href="{{ route('home.index') }}" class="text-white d-block my-2 text-decoration-none">🏠 Home</a>
      <a href="{{ route('quotationlist.index') }}" class="text-white d-block my-2 text-decoration-none">📜 Quotation
        List</a>
      <a href="{{ route('customer') }}" class="text-white d-block my-2 text-decoration-none">
        <i class="fas fa-user"></i> Customer Master
      </a>
    </div>

    <div class="p-4 w-100">
      <div class="bg-white p-4 shadow rounded">
        <div class="d-flex justify-content-between align-items-center border-bottom pb-3 mb-3">
          <h2 class="text-primary">Quotation</h2>
          <img src="{{ URL('images/atjoin_logo.png') }}" alt="Company Logo" class="img-fluid" style="max-width: 120px;">
        </div>

        @if($errors->has('hsn_number'))
        <div class="alert alert-danger">
          {{ $errors->first('hsn_number') }}
        </div>
        @endif

        <form action="{{ route('quotations.store') }}" method="POST">
          @csrf

          <div class="row mb-3">
            <div class="col-md-6">
              <p><strong>Quotation No:</strong> {{ $quotation->quotation_number }}</p>
            </div>
            <div class="col-md-6 text-end">
              <p><strong>Date:</strong> {{ $quotation->quotation_date }}</p>
            </div>
          </div>

          <div class="row mb-4">
            <div class="col-md-6">
              <h5>Quotation From:</h5>
              <address>
                ATJOIN PVT.LTD<br>
                5th Floor, Luv-Kush Apt.<br>
                Seasons Business Center,<br>
                Opp. Kothari Hyundai, Sanewadi, Aundh<br>
                Pune, Maharashtra 411007<br>
                <strong>GST No:</strong> 27AAWCA2027J1ZE<br>
                <strong>Place of Supply:</strong> Pune
              </address>
            </div>
            <div class="col-md-6">
              <h5>Quotation To:</h5>
              @php $selectedCustomer = App\Models\SelectCustomer::first(); @endphp
              @if($selectedCustomer)
              <p><strong>Client Name:</strong> {{ $selectedCustomer->company_name }}</p>
              <p><strong>Customer Name:</strong> {{ $selectedCustomer->customer_name }}</p>
              <p><strong>Contact:</strong> {{ $selectedCustomer->contact }}</p>
              <p><strong>GST Number:</strong> {{ $selectedCustomer->gst_number }}</p>
              <p><strong>Email:</strong> {{ $selectedCustomer->email }}</p>
              <p><strong>Address:</strong> {{ $selectedCustomer->address }}</p>
              <p><strong>State:</strong> {{ $selectedCustomer->state }}</p>
              @endif
            </div>
          </div>

          <table class="table table-bordered text-center mb-4">
            <thead class="table-light">
              <tr>
                <th>Sr No</th>
                <th>Item Description</th>
                <th>Qty</th>
                <th>Amount</th>
                <th>Total Amount</th>
              </tr>
            </thead>
            <tbody>
              @if(isset($selectedRows) && count($selectedRows) > 0)
              @foreach($selectedRows as $row)
              <tr>
                <td><input type="text" name="sr_no[]" class="form-control" value="{{ $row['sr_no'] ?? '' }}" readonly>
                </td>
                <td><input type="text" name="description[]" class="form-control" value="{{ $row['description'] ?? '' }}"
                    readonly></td>
                <td><input type="number" name="quantity[]" class="form-control" value="{{ $row['quantity'] ?? '' }}"
                    readonly></td>
                <td><input type="text" name="amount[]" class="form-control" value="{{ $row['amount'] ?? '' }}" readonly>
                </td>
                <td><input type="text" name="total_amount[]" class="form-control"
                    value="{{ $row['total_amount'] ?? '' }}" readonly></td>
              </tr>
              @endforeach
              @else
              <tr>
                <td colspan="5">No data selected.</td>
              </tr>
              @endif
            </tbody>
          </table>

          <div class="text-end mb-4">
            <p><strong>Sub Total:</strong> ₹{{ number_format($subtotal, 2) }}</p>
            <p><strong>CGST:</strong> ₹{{ number_format($cgst, 2) }}</p>
            <p><strong>SGST:</strong> ₹{{ number_format($sgst, 2) }}</p>
            <p><strong>IGST:</strong> ₹{{ number_format($igst, 2) }}</p>
            <p><strong>Grand Total:</strong> ₹{{ number_format($grand_total, 2) }}</p>
          </div>

          @php
          $isMaharashtra = isset($selectedCustomer) && strtolower($selectedCustomer->state) === 'maharashtra';
          @endphp

          <table class="table table-bordered mb-3">
            <tr>
              <th>HSN/SAC</th>
              <th>Taxable Value</th>
              @if($isMaharashtra)
              <th colspan="2">CGST</th>
              <th colspan="2">SGST</th>
              <th colspan="2" class="text-muted">IGST</th>
              @else
              <th colspan="2" class="text-muted">CGST </th>
              <th colspan="2" class="text-muted">SGST </th>
              <th colspan="2">IGST</th>
              @endif
              <th>Total Tax Amount</th>
            </tr>

            <tr>
              <th></th>
              <th></th>
              @if($isMaharashtra)
              <th>Rate (%)</th>
              <th>Amount (₹)</th>
              <th>Rate (%)</th>
              <th>Amount (₹)</th>
              <th class="text-muted">Rate (%)</th>
              <th class="text-muted">Amount (₹)</th>
              @else
              <th class="text-muted">Rate (%)</th>
              <th class="text-muted">Amount (₹)</th>
              <th class="text-muted">Rate (%)</th>
              <th class="text-muted">Amount (₹)</th>
              <th>Rate (%)</th>
              <th>Amount (₹)</th>
              @endif
              <th></th>
            </tr>

            <tr>
              <td>
                <input type="text" name="hsn_number" placeholder="Enter HSN Number" class="form-control text-center"
                  required>
              </td>
              <td>{{ number_format($gst_rate, 2) }}%</td>

              @if($isMaharashtra)
              <td>{{ $gst_rate / 2 }}%</td>
              <td>₹{{ number_format($cgst, 2) }}</td>
              <td>{{ $gst_rate / 2 }}%</td>
              <td>₹{{ number_format($sgst, 2) }}</td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              @else
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td>{{ $gst_rate }}%</td>
              <td>₹{{ number_format($igst, 2) }}</td>
              @endif

              <td>
                @if($isMaharashtra)
                ₹{{ number_format($cgst + $sgst, 2) }}
                @else
                ₹{{ number_format($igst, 2) }}
                @endif
              </td>
            </tr>

            <tr>
              <td><strong>Total:</strong></td>
              <td><strong>{{ number_format($gst_rate, 2) }}%</strong></td>

              @if($isMaharashtra)
              <td><strong>{{ $gst_rate / 2 }}%</strong></td>
              <td><strong>₹{{ number_format($cgst, 2) }}</strong></td>
              <td><strong>{{ $gst_rate / 2 }}%</strong></td>
              <td><strong>₹{{ number_format($sgst, 2) }}</strong></td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              @else
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td><strong>{{ $gst_rate }}%</strong></td>
              <td><strong>₹{{ number_format($igst, 2) }}</strong></td>
              @endif

              <td>
                <strong>
                  @if($isMaharashtra)
                  ₹{{ number_format($cgst + $sgst, 2) }}
                  @else
                  ₹{{ number_format($igst, 2) }}
                  @endif
                </strong>
              </td>
            </tr>
          </table>


          <div class="mb-4">
            <h5>Terms and Conditions</h5>
            <ul>
              <li>Payment due within 15 days of invoice date.</li>
              <li>Overdue interest at {{ $gst_rate }}% will be charged on delayed payments.</li>
            </ul>
            <h5>Additional Notes</h5>
            <p>This quotation is valid for 30 days from the date of issue.</p>
            <p>This quotation is {{ $gst_type }}</p>
          </div>

          <div class="text-end">
            <button type="submit" class="btn btn-success">Submit Quotation</button>
          </div>

        </form>
      </div>
    </div>
  </div>

</body>

</html>