<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Item;
use App\Models\Subitem;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Session;

class ItemController extends Controller
{
    public function index() {

      
        return view('items');
    }

    public function store(Request $request)
    {
      $request->validate([
        'gst_type' => 'required|string',
        'gst_rate' => 'required|numeric|min:0',
        
    ], [
        'gst_type.required' => 'Please choose GST type.',
        'gst_rate.required' => 'Please select a GST rate.',
        'gst_rate.numeric' => 'GST rate must be a number.',
    ]);
      $selectedRows = [];
      $subtotal = 0;

      $gst_type = $request->input('gst_type'); // Default to 'exclusive' or any valid type
      $gst_rate = (float) $request->input('gst_rate', 0);
  
     
     
    
    // Store manual data (if provided)
    if ($request->has('manual_data')) {
    $manual = $request->manual_data;
    if (!empty($manual['description']) && !empty($manual['quantity']) && !empty($manual['amount']) &&
    !empty($manual['total_amount'])) {
    Item::create([
      'sr_no' => $manual['sr_no'],
    'description' => $manual['description'],
    'quantity' => $manual['quantity'],
    'amount' => $manual['amount'],
    'total_amount' => $manual['total_amount'],
    ]);
    $selectedRows[] = $manual; // Add manual data to the array

    $subtotal += $manual['total_amount']; 
    }
    }
    
     // Store data from uploaded Excel
     if ($request->has('data')) {
      foreach ($request->data as $data) {
          Item::create([
            'sr_no' => $data['sr_no'],
              'description' => $data['description'],
              'quantity' => $data['quantity'],
              'amount' => $data['amount'],
              'total_amount' => $data['total_amount'],
          ]);
          $selectedRows[] = $data;

          $subtotal += $data['total_amount']; 
      }


     // ✅ GST calculation and Subitem storage moved outside Excel condition
     if ($subtotal > 0) {
      $customerState = strtolower($request->input('customer_state'));
      $businessState = strtolower('maharashtra');
      $isSameState = $customerState === $businessState;

     

      // Calculate GST
      if ($gst_type === 'excluding') {
          $gstAmount = $subtotal * ($gst_rate / 100);
          $grandTotal = $subtotal + $gstAmount;
      } else {
          $gstAmount = $subtotal - ($subtotal / (1 + ($gst_rate / 100)));
          $grandTotal = $subtotal;
          $subtotal = $subtotal - $gstAmount;
      }

      $cgst = $sgst = $igst = 0;

      if ($isSameState) {
          $cgst = $gstAmount / 2;
          $sgst = $gstAmount / 2;
      } else {
          $igst = $gstAmount;
      }
    
    Subitem::create([
      'subtotal' => $subtotal,
      'cgst' => $cgst,
      'sgst' => $sgst,
      'igst' => $igst,
      'grand_total' =>$grandTotal,
      'gst_rate' => $gst_rate,
      'gst_type' => $gst_type,
  ]); 
     // Store selected data in session
     Session::put('selected_rows', $selectedRows);
    
    return redirect()->route('quotations.create')->with('success', ' data stored successfully!');
    }
    }

}
}