<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Quotation</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <style>
  @font-face {
    font-family: 'DejaVu Sans';
    font-style: normal;
    font-weight: normal;
    src: url("{{ public_path('fonts/DejaVuSans.ttf') }}") format('truetype');

  }

  @page {
    margin: 2px;
    /* Keep small margins */
  }

  * {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'DejaVu Sans', Arial, sans-serif;
  }

  body {
    font-family: 'DejaVu Sans', Arial, sans-serif;
    font-size: 12px;
    /* Increased by 20% */
    max-width: 97%;
  }

  .container {
    width: 100%;
    margin: 12px auto;
    padding: 12px;
    /* Increased by 20% */
  }

  .header {
    text-align: center;
  }

  .header img {
    max-width: 120px;
    margin-bottom: 10px;
  }

  .billing-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 5px;

  }

  .billing-table th,
  .billing-table td {
    border: 1px #f2f2f2;
    padding: 6px;

    text-align: left;
    vertical-align: top;
    width: 50%;
  }

  .billing-table th {
    background-color: #f2f2f2;
    text-align: left;

    font-weight: bold;
  }

  /* Items Table */

  .table-container {
    width: 100%;
    border-collapse: collapse;
    margin-top: 6px;
    /* Increased */
  }

  .table-container th {
    background-color: #f2f2f2;
  }




  table,
  th {
    border: 1px solid black;
    text-align: center;
    padding: 6px;

  }

  .summary-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 6px;

  }

  .summary-table th {
    background-color: #f2f2f2;
    text-align: center;
    padding: 6px;
  }

  /* Footer Section */

  .footer {
    display: flex;
    justify-content: center;
    margin-top: 16px;

  }

  .footer-table {
    width: 100%;
    border-collapse: collapse;
  }

  .footer-table th,
  .footer-table td {
    border: 1px #f2f2f2;
    padding: 6px;
    /* Increased */
    text-align: center;
    vertical-align: top;
  }

  .footer-table th {
    background-color: #f2f2f2;
    text-align: center;
    font-weight: bold;
  }

  .signature-box {
    text-align: center;
    padding-top: 24px;
    /* Increased */
  }

  /* Total Amount in Words */

  .total-words {
    margin-top: 6px;
    font-weight: bold;
    font-size: 15px;
    /* Increased */
  }

  .btn {
    display: inline-block;
    padding: 10px 20px;
    margin-top: 10px;
    font-size: 16px;
    font-weight: bold;
    text-align: center;
    text-decoration: none;
    color: white;
    background-color: #007bff;
    border: none;
    border-radius: 5px;
    transition: background 0.3s ease;
  }

  .btn:hover {
    background-color: #0056b3;
  }
  </style>
</head>

<body>
  <div class="container">



    <!-- Header -->
    <table class="header" style="width: 100%; border-collapse: collapse; font-size: 12px;">
      <tr>
        <!-- Logo Left -->
        <td style="width: 33%; text-align: left; vertical-align: middle; padding: 10px;">
          @php
          $path = public_path('images/atjoin_logo.png');
          $type = pathinfo($path, PATHINFO_EXTENSION);
          $data = file_get_contents($path);
          $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data);
          @endphp
          <img src="{{ $base64 }}" alt="Logo" width="100">
        </td>

        <!-- Company Name Center -->
        <td style="width: 40%; text-align: center; vertical-align: middle;">
          <strong style="font-size: 16px;">ATJOIN PVT. LTD</strong><br>
          <span style="font-size: 12px;">Sanewadi, Aundh, Pune, Maharashtra 411007</span>
        </td>

        <!-- Quotation Details Right -->
        <td style="width: 33%; text-align: left; vertical-align: middle; padding-left: 30px; margin-left:20px;">
          <strong>Quotation No:</strong> {{ $quotation->quotation_number }}<br>
          <strong>Date:</strong> {{ $quotation->quotation_date }}
        </td>
      </tr>
    </table>

    <!-- Bill To & Ship To -->
    <table class="billing-table">
      <tr>
        <th>Quotation From</th>
        <th>Quotation To</th>
      </tr>
      <tr>
        <td>
          <strong>ATJOIN PVT. LTD</strong><br> 5th Floor, Luv-Kush Apt.<br> Seasons Business Center,<br> Opp. Kothari
          Hyundai Showroom,<br> Sanewadi, Aundh, Pune, Maharashtra 411007
          <p><strong>GSTN.:</strong>27AAWCA2027J1ZE </p>
          <p></p>
        </td>
        <td style:="text-align: right;">
          @php $selectedCustomer = App\Models\SelectCustomer::first(); @endphp @if($selectedCustomer)
          <p><strong>Client Name:</strong> {{ $selectedCustomer->company_name }}</p>
          <p><strong>Customer Name:</strong> {{ $selectedCustomer->customer_name }}</p>
          <p><strong>Contact No.:</strong> {{ $selectedCustomer->contact }}</p>
          <p><strong>GSTN.:</strong> {{ $selectedCustomer->gst_number }}</p>
          <p><strong>Email Id:</strong> {{ $selectedCustomer->email }}</p>
          <p><strong>Address:</strong> {{ $selectedCustomer->address }}</p>
          <p><strong>City:</strong> {{ $selectedCustomer->city }}</p>
          @endif
        </td>
      </tr>
    </table>

    <!-- Items Table -->
    <table class="table-container">
      <tr>
        <th>Sr No</th>
        <th>Items</th>
        <th>HSN</th>
        <th>Unit Price</th>
        <th>Qty</th>
        <th>Amount</th>
      </tr>
      @foreach($quotation->items as $item)
      <tr>
        <td
          style="border-left: 1px solid black; border-right: 1px solid black;  padding-left: 5px; text-align: left; line-height: 1;">
          {{ $item->sr_no }}
        </td>
        <td
          style="border-left: 1px solid black; border-right: 1px solid black;  padding-left: 5px; text-align: left; line-height: 1;">
          {{ $item->description }}
        </td>
        <td style="border-left: 1px solid black; border-right: 1px solid black; padding: 1px; line-height: 1;">
          {{$quotation->hsn_number}}</td>
        <td
          style="border-left: 1px solid black; border-right: 1px solid black; padding: 1px; text-align: right; padding-right:5px; line-height: 1;">
          ₹{{ number_format($item->amount, 2) }}</td>
        <td style="border-left: 1px solid black; border-right: 1px solid black; padding: 1px; line-height: 1;">
          {{ $item->quantity }}
        </td>
        <td
          style="border-left: 1px solid black; border-right: 1px solid black; padding: 3px; text-align: right; padding-right:5px; line-height: 1;">
          ₹{{ number_format($item->total_amount, 2) }}</td>

      </tr>
      @endforeach


      <tr>

        <td colspan="6"
          style="border: 1px solid black; border-left: 1px solid black;  text-align: right; padding-right:5px;">
          <strong>CGST:</strong> ₹{{ number_format($quotation->cgst, 2) }}<br>
          <strong>SGST:</strong> ₹{{ number_format($quotation->sgst, 2) }}<br>
        </td>

      </tr>
      <tr>
        <td colspan="6" style="border: 1px solid black; padding: 10px; text-align: right; padding-left:5px;">

          <strong>Total:</strong> ₹{{ number_format($quotation->grand_total, 2) }}
        </td>
      </tr>
    </table>
    < class="total-words" style="font-size:12px; padding-left:5px; text-align:left;">Total Amount (in words):
      {{ $quotation->grand_total_in_words }} Rupees Only
  </div>

  <!-- Summary Table -->
  <table class="summary-table" border="1" cellpadding="3" cellspacing="0"
    style="width:100%; border-collapse: collapse;">
    <tr>
      <th>HSN/SAC</th>
      <th>Taxable Value</th>
      <th colspan="2">CGST</th>
      <th colspan="2">SGST</th>
      <th>Total Tax Amount</th>
    </tr>
    <tr>

      <!-- Manually Inserted -->
      <th></th>
      <th></th>
      <th>Rate (%)</th>
      <th>Amount (₹)</th>
      <th>Rate (%)</th>
      <th>Amount (₹)</th>
      <th></th>
    </tr>
    <tr>
      <td>{{$quotation->hsn_number}}</td>
      <!-- Manually Inserted -->
      <td>{{ number_format($quotation->gst_rate, 2) }}%</td>
      <td>{{ $quotation->gst_rate / 2 }}%</td>
      <td>₹{{ number_format($quotation->cgst, 2) }}</td>
      <td>{{ $quotation->gst_rate / 2 }}%</td>
      <td>₹{{ number_format($quotation->sgst, 2) }}</td>
      <td>₹{{ number_format($quotation->cgst + $quotation->sgst, 2) }}</td>
    </tr>
    <tr>
      <td><strong>Total:</strong></td>
      <td><strong>{{ number_format($quotation->gst_rate, 2) }}%</strong></td>
      <td><strong>{{ $quotation->gst_rate / 2 }}%</strong></td>
      <td><strong>₹{{ number_format($quotation->cgst, 2) }}</strong></td>
      <td><strong>{{ $quotation->gst_rate / 2 }}%</strong></td>
      <td><strong>₹{{ number_format($quotation->sgst, 2) }}</strong></td>
      <td><strong>₹{{ number_format($quotation->cgst + $quotation->sgst, 2) }}</strong></td>
    </tr>
  </table>


  <!-- Footer -->
  <div class="footer">
    <table class="footer-table">
      <tr>
        <th style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">Bank Details</th>
        <th style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">Terms and Conditions
        </th>
        <th style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">Authorized Signature
        </th>
      </tr>
      <tr>
        <td style="border-left: 1px solid black; border-right: 1px solid black; text-align: left; padding: 10px;">
          <strong>Name:</strong> ATJOIN PRIVATE LIMITED<br>
          <strong>IFSC Code:</strong>MAHB0000277<br>
          <strong>Account No:</strong> 60402360743<br>
          <strong>Bank:</strong> Bank of Maharashtra
        </td>
        <td style="border-left: 1px solid black; border-right: 1px solid black; text-align:left;  padding: 10px;">
          1. Payment due within 15 days.<br> 2. Overdue interest at {{$quotation->gst_rate}}% will be <br>charged on
          delayed payments.
        </td>
        <td class="signature-box"
          style="border-left: 1px solid black; border-right: 1px solid black; text-align: left; padding: 10px;">
          (Sign & Stamp)
        </td>
      </tr>
    </table>
  </div>

  </div>
  </div>
</body>

</html>