<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Quotation</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <style>
  .container {
    margin-top: 20px;
  }

  .summary p {
    font-weight: bold;
  }
  </style>
</head>

<body>
  <div class="container">
    <h2>Edit Quotation</h2>
    <form action="{{ route('quotationlist.update', $quotation->id) }}" method="POST">
      @csrf
      @method('PUT')

      <div class="mb-3">
        <label>Quotation Number:</label>
        <input type="text" name="quotation_number" value="{{ $quotation->quotation_number }}" class="form-control"
          required>
      </div>

      <div class="mb-3">
        <label>Customer Name:</label>
        <input type="text" name="customer_name" value="{{ $quotation->customer_name }}" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Quotation Date:</label>
        <input type="date" name="quotation_date" value="{{ $quotation->quotation_date }}" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>GST Rate (%):</label>
        <input type="number" id="gst_rate" name="gst_rate" value="{{ $quotation->gst_rate }}" class="form-control"
          required>
      </div>
      <div class="mb-3">
        <label>GST Type:</label>
        <input id="gst_type" name="gst_type" value="{{ $quotation->gst_type }}" class="form-control" required readonly>
      </div>

      <table class="table" id="itemsTable">
        <thead>
          <tr>
            <th>Sr No</th>
            <th>Item Description</th>
            <th>Qty</th>
            <th>Price</th>
            <th>Total Amount</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($quotationitems as $index => $item)
          <tr>
            <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
            <td>
              <input type="number" name="items[{{ $index }}][sr_no]" value="{{ $item->sr_no ?? $index + 1 }}"
                class="form-control" required>
            </td>

            <td><input type="text" name="items[{{ $index }}][description]" class="form-control"
                value="{{ $item->description }}" required></td>
            <td><input type="number" name="items[{{ $index }}][quantity]" class="form-control quantity"
                value="{{ $item->quantity }}" required></td>
            <td><input type="number" name="items[{{ $index }}][price]" class="form-control price"
                value="{{ $item->amount }}" required></td>
            <td><input type="text" name="items[{{ $index }}][total]" class="form-control total"
                value="{{ $item->total_amount }}" readonly></td>
            <td><button type="button" class="btn btn-danger remove-item">X</button></td>
          </tr>
          @endforeach
        </tbody>
      </table>

      <button type="button" id="addItem" class="btn btn-primary">Add Item</button>

      <div class="summary mt-3">
        <p><strong>Sub Total:</strong> ₹<span id="subtotal">0.00</span></p>
        <p><strong>CGST:</strong> ₹<span id="cgst">0.00</span></p>
        <p><strong>SGST:</strong> ₹<span id="sgst">0.00</span></p>
        <p><strong>Grand Total:</strong> ₹<span id="grand_total">0.00</span></p>
      </div>

      <button type="submit" class="btn btn-success">Update Quotation</button>
    </form>
  </div>

  <script>
  document.addEventListener("DOMContentLoaded", function() {
    function calculateTotals() {
      let subtotal = 0;
      document.querySelectorAll(".total").forEach(input => {
        subtotal += parseFloat(input.value) || 0;
      });

      const gstRate = parseFloat(document.getElementById("gst_rate").value) || 0;
      const gstType = document.getElementById("gst_type").value;

      let cgst = 0,
        sgst = 0,
        grandTotal = 0;

      if (gstType === 'excluding') {
        // GST will be added on top
        cgst = subtotal * (gstRate / 2) / 100;
        sgst = subtotal * (gstRate / 2) / 100;
        grandTotal = subtotal + cgst + sgst;
      } else {
        // GST is already included in total
        let gstMultiplier = (100 + gstRate) / 100;
        let baseAmount = subtotal / gstMultiplier;
        cgst = baseAmount * (gstRate / 2) / 100;
        sgst = baseAmount * (gstRate / 2) / 100;
        subtotal = baseAmount;
        grandTotal = subtotal + cgst + sgst;
      }

      document.getElementById("subtotal").innerText = subtotal.toFixed(2);
      document.getElementById("cgst").innerText = cgst.toFixed(2);
      document.getElementById("sgst").innerText = sgst.toFixed(2);
      document.getElementById("grand_total").innerText = grandTotal.toFixed(2);
    }

    document.querySelector("#itemsTable").addEventListener("input", function(event) {
      if (event.target.classList.contains("quantity") || event.target.classList.contains("price")) {
        let row = event.target.closest("tr");
        let quantity = parseFloat(row.querySelector(".quantity").value) || 0;
        let price = parseFloat(row.querySelector(".price").value) || 0;
        let total = quantity * price;
        row.querySelector(".total").value = total.toFixed(2);
        calculateTotals();
      }
    });

    document.getElementById("addItem").addEventListener("click", function() {
      let rowCount = document.querySelectorAll("#itemsTable tbody tr").length;
      let newRow = `
        <tr>
           <td><input type="number" name="items[${rowCount}][sr_no]"  class="form-control" required></td>
          <td><input type="text" name="items[${rowCount}][description]" class="form-control" required></td>
          <td><input type="number" name="items[${rowCount}][quantity]" class="form-control quantity" required></td>
          <td><input type="number" name="items[${rowCount}][price]" class="form-control price" required></td>
          <td><input type="text" name="items[${rowCount}][total]" class="form-control total" readonly></td>
          <td><button type="button" class="btn btn-danger remove-item">X</button></td>
        </tr>`;
      document.querySelector("#itemsTable tbody").insertAdjacentHTML("beforeend", newRow);
    });

    document.querySelector("#itemsTable").addEventListener("click", function(event) {
      if (event.target.classList.contains("remove-item")) {
        event.target.closest("tr").remove();
        calculateTotals();
      }
    });

    document.getElementById("gst_rate").addEventListener("input", calculateTotals);
    document.getElementById("gst_type").addEventListener("change", calculateTotals);

    calculateTotals(); // Initial call
  });
  </script>

</body>

</html>