<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Quotation List</title>

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <!-- Font Awesome for Icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

</head>

<style>
/* General Styling */
body {
  background-color: #f8f9fa;
  display: flex;
  height: 100vh;
  overflow-x: hidden;
}

/* Sidebar Styling */
.sidebar {
  width: 250px;
  background: linear-gradient(135deg, #2c3e50, #2a5298);
  padding: 20px;
  color: white;
  height: 100%;
  position: fixed;
  left: 0;
  top: 0;
}

.sidebar img {
  width: 100px;
  height: auto;
  margin-bottom: 20px;
}

.sidebar a {
  display: block;
  color: white;
  text-decoration: none;
  padding: 10px;
  margin: 10px 0;
  border-radius: 5px;
  transition: 0.3s;
  font-size: 16px;
}

.sidebar a:hover {
  background-color: rgba(255, 255, 255, 0.2);
}

/* Logout Button */
.logout-btn {
  background-color: #dc3545;
  color: white;
  font-weight: bold;
  border-radius: 5px;
  padding: 10px;
  text-decoration: none;
  display: flex;
  align-items: center;
  justify-content: center;
  width: 100%;
  margin-top: 20px;
  transition: 0.3s;
}

.logout-btn:hover {
  background-color: #c82333;
  color: white;
}

.logout-btn i {
  margin-right: 8px;
}

/* Navbar Styling */
.navbar {
  margin-left: 250px;
  background: linear-gradient(135deg, #2a5298, #1e3c72);
  padding: 15px;
  color: white;
  display: flex;
  align-items: center;
  justify-content: center;
  position: fixed;
  top: 0;
  z-index: 1000;
  width: calc(100% - 250px);
}

.navbar h4 {
  margin: 0;
}

/* Table Styling */
.table-container {
  margin-top: 80px;
  margin-left: 250px;
  padding: 20px;
}

.table {
  text-align: center;
  background: white;
}

/* Button Styling */
.btn-sm i {
  margin-right: 5px;
}

.btn-sm:hover {
  transform: scale(1.05);
  transition: 0.2s;
}

/* Responsive Sidebar */
@media (max-width: 768px) {
  .sidebar {
    width: 200px;
  }

  .navbar {
    margin-left: 200px;
    width: calc(100% - 200px);
  }

  .table-container {
    margin-left: 200px;
  }
}
</style>

<body>
  <!-- Sidebar -->
  <div class="sidebar">
    <img src="<?php echo e(asset('images/atjoin_logo.png')); ?>" alt="Company Logo">
    <h3>Dashboard</h3>
    <a href="<?php echo e(route('home.index')); ?>">🏠 Home</a>
    <a href="<?php echo e(route('quotationlist.index')); ?>">📜 Quotation List</a>
    <a href="<?php echo e(route('customer')); ?>" class="text-white">
      <i class="fas fa-user"></i> Customer Master
    </a>


  </div>

  <!-- Navbar -->
  <div class="navbar">
    <h4>Quotation List</h4>
  </div>

  <!-- Main Content -->
  <div class="container table-container">
    <?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table table-bordered">
      <thead class="table-dark">
        <tr>
          <th>Quotation No</th>
          <th>Customer Name</th>
          <th>Contact</th>
          <th>Customer Email</th>
          <th>Update</th>
          <th>Delete</th>
          <th>Download PDF</th>
          <th>Generate Invoice</th>
          <th>Edit Invoice</th>

        </tr>
      </thead>
      <tbody>
        <?php $__currentLoopData = $quotations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $quotation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
          <td><?php echo e($quotation->quotation_number); ?></td>
          <td><?php echo e($quotation->customer_name); ?></td>
          <td><?php echo e($quotation->contact); ?></td>
          <td><?php echo e($quotation->email); ?></td>
          <td>
            <a href="<?php echo e(route('quotation.edit', $quotation->id)); ?>" class="btn btn-warning btn-sm">
              <i class="fas fa-edit"></i> Edit
            </a>
          </td>
          <td>
            <form action="<?php echo e(route('quotationlist.delete', $quotation->id)); ?>" method="POST">
              <?php echo csrf_field(); ?>
              <?php echo method_field('DELETE'); ?>
              <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">
                <i class="fas fa-trash"></i> Delete
              </button>
            </form>
          </td>
          <td>
            <a href="<?php echo e(route('quotationlist.pdf', $quotation->id)); ?>" class="btn btn-primary btn-sm">
              <i class="fas fa-file-pdf"></i> PDF
            </a>
          </td>
          <td>
            <a href="<?php echo e(route('quotationlist.invoice', $quotation->id)); ?>" class="btn btn-primary btn-sm">
              <i class="fas fa-file-invoice"></i> Generate Invoice
            </a>
          </td>
          <td>
            <a href="<?php echo e(route('quotationlist.invoiceedit', $quotation->id)); ?>" class="btn btn-success btn-sm">
              <i class="fas fa-pen"></i> Edit Invoice
            </a>
          </td>

        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
    </table>
    <!-- Pagination -->
    <div class="d-flex justify-content-center mt-3">
      <?php echo e($quotations->links()); ?>

    </div>
  </div>
</body>

</html><?php /**PATH /home/mcndhanoreco/public_html/quotation.mcndhanore.co.in/my-quote/resources/views/quotation_list.blade.php ENDPATH**/ ?>