
<?php $__env->startSection('title', 'Create Quotation'); ?>




<?php if(session('success')): ?>
<div class="alert alert-success">
  <?php echo e(session('success')); ?>

</div>
<?php endif; ?>
<?php $__errorArgs = ['hsn_number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
<span class="text-danger"><?php echo e($message); ?></span>
<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


<?php $__env->startSection('content'); ?>
<div class="container quotation-box">
  <div class="header">
    <h2>Quotation</h2>
    <img src="<?php echo e(URL('images/atjoin_logo.png')); ?>" alt="Company Logo">
  </div>

  <form action="<?php echo e(route('quotations.store')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="row quotation-details">
      <div class="col-md-6">
        <p><strong>Quotation No:</strong> <?php echo e($quotation->quotationNumber ?? $quotationNumber); ?></p>
      </div>
      <div class="col-md-6 text-end">

        <p><strong>Date:</strong> <?php echo e($quotation->quotationDate); ?></p>

      </div>
    </div>

    <div class="row company-details">
      <div class="col-md-6">
        <h5>Quotation From:</h5>
        <p>ATJOIN PVT.LTD<br>5th Floor, Luv-Kush Apt.<br>Seasons Business Center,<br>Opposite Kothari Hyundai
          Showroom,<br>Sanewadi, Aundh <br>Pune, Maharashtra 411007</p>
        <p><strong>Place of Supply:</strong> Pune</p>
      </div>

      <div class="col-md-6 " style="text-align: left; padding-left: 300px;">
        <h5>Quotation To:</h5>

        <?php
        $selectedCustomer = App\Models\SelectCustomer::first();
        ?>
        <?php if($selectedCustomer): ?>

        <p><strong>Client Name:</strong> <?php echo e($selectedCustomer->company_name); ?></p>
        <p><strong>Customer Name:</strong> <?php echo e($selectedCustomer->customer_name); ?></p>
        <p><strong>Contact:</strong> <?php echo e($selectedCustomer->contact); ?></p>
        <p><strong>GST Number:</strong> <?php echo e($selectedCustomer->gst_number); ?></p>
        <p><strong>Email:</strong> <?php echo e($selectedCustomer->email); ?></p>
        <p><strong>Address:</strong> <?php echo e($selectedCustomer->address); ?></p>
        <p><strong>State:</strong> <?php echo e($selectedCustomer->state); ?></p>
        <?php endif; ?>

      </div>


      <table class="table table-bordered mt-3">
        <thead>
          <tr>
            <th>Sr No</th>
            <th>Item Description</th>
            <th>Qty</th>
            <th>Amount</th>
            <th>Total Amount</th>
          </tr>
        </thead>
        <tbody>
          <?php if(isset($selectedRows) && count($selectedRows) > 0): ?>
          <?php $__currentLoopData = $selectedRows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><input type="text" name="sr_no[]" class="form-control" value="<?php echo e($row['sr_no'] ?? ''); ?>" readonly>
            </td>
            <td><input type="text" name="description[]" class="form-control" value="<?php echo e($row['description'] ?? ''); ?>"
                readonly></td>
            <td><input type="number" name="quantity[]" class="form-control" value="<?php echo e($row['quantity'] ?? ''); ?>"
                readonly>
            </td>
            <td><input type="text" name="amount[]" class="form-control" value="<?php echo e($row['amount'] ?? ''); ?>" readonly>
            </td>
            <td><input type="text" name="total_amount[]" class="form-control" value="<?php echo e($row['total_amount'] ?? ''); ?>"
                readonly></td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
          <?php else: ?>
          <tr>
            <td colspan="4" class="text-center">No data selected.</td>
          </tr>
          <?php endif; ?>

        </tbody>
      </table>

      <div class="text-end">
        <p><strong>Sub Total:</strong> ₹<?php echo e(number_format($subtotal, 2)); ?></p>
        <p><strong>CGST :</strong> ₹<?php echo e(number_format($cgst, 2)); ?></p>
        <p><strong>SGST :</strong> ₹<?php echo e(number_format($sgst, 2)); ?></p>
        <p><strong>IGST :</strong> ₹<?php echo e(number_format($igst, 2)); ?></p>
        <p><strong>Grand Total:</strong> ₹<?php echo e(number_format($grand_total, 2)); ?></p>
      </div>

      <?php
      $isMaharashtra = isset($selectedCustomer) && strtolower($selectedCustomer->state) === 'maharashtra';
      ?>

      <table class="table table-bordered mb-3">
        <tr>
          <th>HSN/SAC</th>
          <th>Taxable Value</th>
          <?php if($isMaharashtra): ?>
          <th colspan="2">CGST</th>
          <th colspan="2">SGST</th>
          <th colspan="2" class="text-muted">IGST</th>
          <?php else: ?>
          <th colspan="2" class="text-muted">CGST </th>
          <th colspan="2" class="text-muted">SGST </th>
          <th colspan="2">IGST</th>
          <?php endif; ?>
          <th>Total Tax Amount</th>
        </tr>

        <tr>
          <th></th>
          <th></th>
          <?php if($isMaharashtra): ?>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <th class="text-muted">Rate (%)</th>
          <th class="text-muted">Amount (₹)</th>
          <?php else: ?>
          <th class="text-muted">Rate (%)</th>
          <th class="text-muted">Amount (₹)</th>
          <th class="text-muted">Rate (%)</th>
          <th class="text-muted">Amount (₹)</th>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <?php endif; ?>
          <th></th>
        </tr>

        <tr>
          <td>
            <input type="text" name="hsn_number" placeholder="Enter HSN Number" class="form-control text-center"
              required>
          </td>
          <td><?php echo e(number_format($gst_rate, 2)); ?>%</td>

          <?php if($isMaharashtra): ?>
          <td><?php echo e($gst_rate / 2); ?>%</td>
          <td>₹<?php echo e(number_format($cgst, 2)); ?></td>
          <td><?php echo e($gst_rate / 2); ?>%</td>
          <td>₹<?php echo e(number_format($sgst, 2)); ?></td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <?php else: ?>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td><?php echo e($gst_rate); ?>%</td>
          <td>₹<?php echo e(number_format($igst, 2)); ?></td>
          <?php endif; ?>

          <td>
            <?php if($isMaharashtra): ?>
            ₹<?php echo e(number_format($cgst + $sgst, 2)); ?>

            <?php else: ?>
            ₹<?php echo e(number_format($igst, 2)); ?>

            <?php endif; ?>
          </td>
        </tr>

        <tr>
          <td><strong>Total:</strong></td>
          <td><strong><?php echo e(number_format($gst_rate, 2)); ?>%</strong></td>

          <?php if($isMaharashtra): ?>
          <td><strong><?php echo e($gst_rate / 2); ?>%</strong></td>
          <td><strong>₹<?php echo e(number_format($cgst, 2)); ?></strong></td>
          <td><strong><?php echo e($gst_rate / 2); ?>%</strong></td>
          <td><strong>₹<?php echo e(number_format($sgst, 2)); ?></strong></td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <?php else: ?>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td><strong><?php echo e($gst_rate); ?>%</strong></td>
          <td><strong>₹<?php echo e(number_format($igst, 2)); ?></strong></td>
          <?php endif; ?>

          <td>
            <strong>
              <?php if($isMaharashtra): ?>
              ₹<?php echo e(number_format($cgst + $sgst, 2)); ?>

              <?php else: ?>
              ₹<?php echo e(number_format($igst, 2)); ?>

              <?php endif; ?>
            </strong>
          </td>
        </tr>
      </table>


      <div class="w-50">
        <button type="submit" class="btn btn-primary">Save</button>
      </div>

  </form>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\xampp\htdocs\quotation-builder\resources\views\quotations\create.blade.php ENDPATH**/ ?>