<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Quotation</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.0.2/dist/js/bootstrap.bundle.min.js"></script>
</head>

<body class="bg-light">

  <div class="d-flex">
    <div class="p-4 text-white  vh-100%" style="width: 250px;  background: linear-gradient(135deg, #2c3e50, #2a5298);">
      <div class="text-center mb-4">
        <img src="<?php echo e(URL('images/atjoin_logo.png')); ?>" alt="Logo" class="img-fluid" style="max-width: 100px;">
      </div>
      <h5>Dashboard</h5>
      <a href="<?php echo e(route('home.index')); ?>" class="text-white d-block my-2 text-decoration-none">🏠 Home</a>
      <a href="<?php echo e(route('quotationlist.index')); ?>" class="text-white d-block my-2 text-decoration-none">📜 Quotation
        List</a>
      <a href="<?php echo e(route('customer')); ?>" class="text-white d-block my-2 text-decoration-none">
        <i class="fas fa-user"></i> Customer Master
      </a>
    </div>

    <div class="p-4 w-100">
      <div class="bg-white p-4 shadow rounded">
        <div class="d-flex justify-content-between align-items-center border-bottom pb-3 mb-3">
          <h2 class="text-primary">Quotation</h2>
          <img src="<?php echo e(URL('images/atjoin_logo.png')); ?>" alt="Company Logo" class="img-fluid" style="max-width: 120px;">
        </div>

        <?php if($errors->has('hsn_number')): ?>
        <div class="alert alert-danger">
          <?php echo e($errors->first('hsn_number')); ?>

        </div>
        <?php endif; ?>

        <form action="<?php echo e(route('quotations.store')); ?>" method="POST">
          <?php echo csrf_field(); ?>

          <div class="row mb-3">
            <div class="col-md-6">
              <p><strong>Quotation No:</strong> <?php echo e($quotation->quotation_number); ?></p>
            </div>
            <div class="col-md-6 text-end">
              <p><strong>Date:</strong> <?php echo e($quotation->quotation_date); ?></p>
            </div>
          </div>

          <div class="row mb-4">
            <div class="col-md-6">
              <h5>Quotation From:</h5>
              <address>
                ATJOIN PVT.LTD<br>
                5th Floor, Luv-Kush Apt.<br>
                Seasons Business Center,<br>
                Opp. Kothari Hyundai, Sanewadi, Aundh<br>
                Pune, Maharashtra 411007<br>
                <strong>GST No:</strong> 27AAWCA2027J1ZE<br>
                <strong>Place of Supply:</strong> Pune
              </address>
            </div>
            <div class="col-md-6">
              <h5>Quotation To:</h5>
              <?php $selectedCustomer = App\Models\SelectCustomer::first(); ?>
              <?php if($selectedCustomer): ?>
              <p><strong>Client Name:</strong> <?php echo e($selectedCustomer->company_name); ?></p>
              <p><strong>Customer Name:</strong> <?php echo e($selectedCustomer->customer_name); ?></p>
              <p><strong>Contact:</strong> <?php echo e($selectedCustomer->contact); ?></p>
              <p><strong>GST Number:</strong> <?php echo e($selectedCustomer->gst_number); ?></p>
              <p><strong>Email:</strong> <?php echo e($selectedCustomer->email); ?></p>
              <p><strong>Address:</strong> <?php echo e($selectedCustomer->address); ?></p>
              <p><strong>State:</strong> <?php echo e($selectedCustomer->state); ?></p>
              <?php endif; ?>
            </div>
          </div>

          <table class="table table-bordered text-center mb-4">
            <thead class="table-light">
              <tr>
                <th>Sr No</th>
                <th>Item Description</th>
                <th>Qty</th>
                <th>Amount</th>
                <th>Total Amount</th>
              </tr>
            </thead>
            <tbody>
              <?php if(isset($selectedRows) && count($selectedRows) > 0): ?>
              <?php $__currentLoopData = $selectedRows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <tr>
                <td><input type="text" name="sr_no[]" class="form-control" value="<?php echo e($row['sr_no'] ?? ''); ?>" readonly>
                </td>
                <td><input type="text" name="description[]" class="form-control" value="<?php echo e($row['description'] ?? ''); ?>"
                    readonly></td>
                <td><input type="number" name="quantity[]" class="form-control" value="<?php echo e($row['quantity'] ?? ''); ?>"
                    readonly></td>
                <td><input type="text" name="amount[]" class="form-control" value="<?php echo e($row['amount'] ?? ''); ?>" readonly>
                </td>
                <td><input type="text" name="total_amount[]" class="form-control"
                    value="<?php echo e($row['total_amount'] ?? ''); ?>" readonly></td>
              </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <tr>
                <td colspan="5">No data selected.</td>
              </tr>
              <?php endif; ?>
            </tbody>
          </table>

          <div class="text-end mb-4">
            <p><strong>Sub Total:</strong> ₹<?php echo e(number_format($subtotal, 2)); ?></p>
            <p><strong>CGST:</strong> ₹<?php echo e(number_format($cgst, 2)); ?></p>
            <p><strong>SGST:</strong> ₹<?php echo e(number_format($sgst, 2)); ?></p>
            <p><strong>IGST:</strong> ₹<?php echo e(number_format($igst, 2)); ?></p>
            <p><strong>Grand Total:</strong> ₹<?php echo e(number_format($grand_total, 2)); ?></p>
          </div>

          <?php
          $isMaharashtra = isset($selectedCustomer) && strtolower($selectedCustomer->state) === 'maharashtra';
          ?>

          <table class="table table-bordered mb-3">
            <tr>
              <th>HSN/SAC</th>
              <th>Taxable Value</th>
              <?php if($isMaharashtra): ?>
              <th colspan="2">CGST</th>
              <th colspan="2">SGST</th>
              <th colspan="2" class="text-muted">IGST</th>
              <?php else: ?>
              <th colspan="2" class="text-muted">CGST </th>
              <th colspan="2" class="text-muted">SGST </th>
              <th colspan="2">IGST</th>
              <?php endif; ?>
              <th>Total Tax Amount</th>
            </tr>

            <tr>
              <th></th>
              <th></th>
              <?php if($isMaharashtra): ?>
              <th>Rate (%)</th>
              <th>Amount (₹)</th>
              <th>Rate (%)</th>
              <th>Amount (₹)</th>
              <th class="text-muted">Rate (%)</th>
              <th class="text-muted">Amount (₹)</th>
              <?php else: ?>
              <th class="text-muted">Rate (%)</th>
              <th class="text-muted">Amount (₹)</th>
              <th class="text-muted">Rate (%)</th>
              <th class="text-muted">Amount (₹)</th>
              <th>Rate (%)</th>
              <th>Amount (₹)</th>
              <?php endif; ?>
              <th></th>
            </tr>

            <tr>
              <td>
                <input type="text" name="hsn_number" placeholder="Enter HSN Number" class="form-control text-center"
                  required>
              </td>
              <td><?php echo e(number_format($gst_rate, 2)); ?>%</td>

              <?php if($isMaharashtra): ?>
              <td><?php echo e($gst_rate / 2); ?>%</td>
              <td>₹<?php echo e(number_format($cgst, 2)); ?></td>
              <td><?php echo e($gst_rate / 2); ?>%</td>
              <td>₹<?php echo e(number_format($sgst, 2)); ?></td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <?php else: ?>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td><?php echo e($gst_rate); ?>%</td>
              <td>₹<?php echo e(number_format($igst, 2)); ?></td>
              <?php endif; ?>

              <td>
                <?php if($isMaharashtra): ?>
                ₹<?php echo e(number_format($cgst + $sgst, 2)); ?>

                <?php else: ?>
                ₹<?php echo e(number_format($igst, 2)); ?>

                <?php endif; ?>
              </td>
            </tr>

            <tr>
              <td><strong>Total:</strong></td>
              <td><strong><?php echo e(number_format($gst_rate, 2)); ?>%</strong></td>

              <?php if($isMaharashtra): ?>
              <td><strong><?php echo e($gst_rate / 2); ?>%</strong></td>
              <td><strong>₹<?php echo e(number_format($cgst, 2)); ?></strong></td>
              <td><strong><?php echo e($gst_rate / 2); ?>%</strong></td>
              <td><strong>₹<?php echo e(number_format($sgst, 2)); ?></strong></td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <?php else: ?>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td class="text-muted">—</td>
              <td><strong><?php echo e($gst_rate); ?>%</strong></td>
              <td><strong>₹<?php echo e(number_format($igst, 2)); ?></strong></td>
              <?php endif; ?>

              <td>
                <strong>
                  <?php if($isMaharashtra): ?>
                  ₹<?php echo e(number_format($cgst + $sgst, 2)); ?>

                  <?php else: ?>
                  ₹<?php echo e(number_format($igst, 2)); ?>

                  <?php endif; ?>
                </strong>
              </td>
            </tr>
          </table>


          <div class="mb-4">
            <h5>Terms and Conditions</h5>
            <ul>
              <li>Payment due within 15 days of invoice date.</li>
              <li>Overdue interest at <?php echo e($gst_rate); ?>% will be charged on delayed payments.</li>
            </ul>
            <h5>Additional Notes</h5>
            <p>This quotation is valid for 30 days from the date of issue.</p>
            <p>This quotation is <?php echo e($gst_type); ?></p>
          </div>

          <div class="text-end">
            <button type="submit" class="btn btn-success">Submit Quotation</button>
          </div>

        </form>
      </div>
    </div>
  </div>

</body>

</html><?php /**PATH /home/mcndhanoreco/public_html/quotation.mcndhanore.co.in/my-quote/resources/views/layouts/app.blade.php ENDPATH**/ ?>