<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Quotation</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <style>
  .container {
    margin-top: 20px;
  }

  .summary p {
    font-weight: bold;
  }
  </style>
  <div class="container">
    <h2>Edit Quotation</h2>

    <form action="<?php echo e(route('quotationlist.destroy', $quotation->id)); ?>" method="POST"
      onsubmit="return confirm('Are you sure you want to delete this quotation?');">
      <?php echo csrf_field(); ?>
      <?php echo method_field('DELETE'); ?>

      <div class="mb-3">
        <label>Quotation Number:</label>
        <input type="text" name="quotation_number" value="<?php echo e($quotation->quotation_number); ?>" class="form-control"
          required>
      </div>

      <div class="mb-3">
        <label>Customer Name:</label>
        <input type="text" name="customer_name" value="<?php echo e($quotation->customer_name); ?>" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Quotation Date:</label>
        <input type="date" name="quotation_date" value="<?php echo e($quotation->quotation_date); ?>" class="form-control" required>
      </div>



      <!-- Items Table -->
      <table class="table" id="itemsTable">
        <thead>
          <tr>
            <th>Item Description</th>
            <th>Qty</th>
            <th>Amount</th>
            <th>Total Amount</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $quotationitems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <input type="hidden" name="items[<?php echo e($loop->index); ?>][id]" value="<?php echo e($item->id); ?>">
            <td><input type="text" name="items[<?php echo e($loop->index); ?>][description]" class="form-control"
                value="<?php echo e($item->description); ?>" required></td>
            <td><input type="number" name="items[<?php echo e($loop->index); ?>][quantity]" class="form-control quantity"
                value="<?php echo e($item->quantity); ?>" required></td>
            <td><input type="number" name="items[<?php echo e($loop->index); ?>][price]" class="form-control price"
                value="<?php echo e($item->amount); ?>" required></td>
            <td><input type="text" name="items[<?php echo e($loop->index); ?>][total]" class="form-control total"
                value="<?php echo e($item->total_amount); ?>" readonly></td>
            <td><button type="button" class="btn btn-danger remove-item">X</button></td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>



      <!-- Summary -->
      <div class="summary">
        <p><strong>Sub Total:</strong> ₹<span id="subtotal"><?php echo e(number_format($quotation->subtotal, 2)); ?></span></p>
        <p><strong>CGST:</strong> ₹<span id="cgst"><?php echo e(number_format($quotation->cgst, 2)); ?></span></p>
        <p><strong>SGST:</strong> ₹<span id="sgst"><?php echo e(number_format($quotation->sgst, 2)); ?></span></p>
        <p><strong>Grand Total:</strong> ₹<span id="grand_total"><?php echo e(number_format($quotation->grand_total, 2)); ?></span>
        </p>
      </div>

      <button type="submit" class="btn btn-danger">Delete</button>
    </form>
  </div>

  <script>
  document.addEventListener("DOMContentLoaded", function() {


    calculateTotals();

    document.querySelector("#itemsTable").addEventListener("input", function(event) {
      if (event.target.classList.contains("quantity") || event.target.classList.contains("price")) {
        let row = event.target.closest("tr");
        let quantity = row.querySelector(".quantity").value;
        let price = row.querySelector(".price").value;
        let total = (quantity * price).toFixed(2);
        row.querySelector(".total").value = total;
        calculateTotals();
      }
    });

    function calculateTotals() {
      let subtotal = 0;
      document.querySelectorAll(".total").forEach(function(input) {
        subtotal += parseFloat(input.value) || 0;
      });
      document.getElementById("subtotal").innerText = subtotal.toFixed(2);
      let cgst = (subtotal * 0.09).toFixed(2);
      let sgst = (subtotal * 0.09).toFixed(2);
      let grandTotal = (subtotal + parseFloat(cgst) + parseFloat(sgst)).toFixed(2);

      document.getElementById("cgst").innerText = cgst;
      document.getElementById("sgst").innerText = sgst;
      document.getElementById("grand_total").innerText = grandTotal;
    }

    document.getElementById("addItem").addEventListener("click", function() {
      let rowCount = document.querySelectorAll("#itemsTable tbody tr").length;
      let newRow = `
      <tr>
          <input type="hidden" name="items[${rowCount}][id]" value="">
          <td><input type="text" name="items[${rowCount}][description]" class="form-control" required></td>
          <td><input type="number" name="items[${rowCount}][quantity]" class="form-control quantity" required></td>
          <td><input type="number" name="items[${rowCount}][price]" class="form-control price" required></td>
          <td><input type="text" name="items[${rowCount}][total]" class="form-control total" readonly></td>
          <td><button type="button" class="btn btn-danger remove-item">X</button></td>
      </tr>`;
      document.querySelector("#itemsTable tbody").insertAdjacentHTML("beforeend", newRow);
    });

    document.querySelector("#itemsTable").addEventListener("click", function(event) {
      if (event.target.classList.contains("remove-item")) {
        event.target.closest("tr").remove();
        calculateTotals();
      }
    });




  });
  </script>
  </body>

</html><?php /**PATH D:\xampp\htdocs\quotation-builder\resources\views\quotationlist\delete.blade.php ENDPATH**/ ?>