<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Customer Master</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <style>
  body {
    background-color: #f8f9fa;
    display: flex;
    height: 100vh;
  }

  /* Sidebar Styling */

  .sidebar {
    width: 250px;
    background: linear-gradient(135deg, #2c3e50, #2a5298);
    padding: 20px;
    color: white;
    height: 100%;
    position: fixed;
    left: 0;
    top: 0;
  }

  .sidebar img {
    width: 100px;
    height: auto;
    margin-bottom: 20px;
  }

  .sidebar a {
    display: block;
    color: white;
    text-decoration: none;
    padding: 10px;
    margin: 10px 0;
    border-radius: 5px;
    transition: 0.3s;
  }

  .sidebar a:hover {
    background-color: rgb(63, 125, 206);
  }

  .logout-btn {
    background-color: #dc3545;
    color: white;
    font-weight: bold;
    border-radius: 5px;
    padding: 10px;
    text-decoration: none;
    display: inline-block;
    width: 100%;
    text-align: center;
  }

  .logout-btn:hover {
    background-color: #c82333;
    color: white;
  }

  /* Navbar Styling */

  .navbar {

    margin-left: 250px;
    background: linear-gradient(135deg, #2a5298, #1e3c72);
    padding: 15px;
    color: white;
    display: flex;

    align-items: center;
    justify-content: center;
    /* Center the content */
    position: fixed;
    top: 0;
    z-index: 1000;
    width: calc(100% - 200px);
  }

  /* Main Content */

  .content {
    margin-top: 30px;
    margin-left: 255px;
    padding: 20px;
    width: 100%;
    text-align: center;
  }

  .card {
    background: rgba(234, 193, 234, 0.57);
    box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
    border-radius: 8px;
    margin-bottom: 20px;
    margin-top: 90px;
    transition: transform 0.3s ease, box-shadow 0.3s ease;
  }

  .card:hover {
    transform: translateY(-10px);
    box-shadow: 0px 10px 20px rgba(0, 0, 0, 0.2);
  }

  /* Responsive Design */

  @media (max-width: 768px) {
    .sidebar {
      width: 200px;
    }

    .navbar {
      margin-left: 200px;
      width: calc(100% - 200px);
    }


  }
  </style>
</head>

<body>
  <div class="sidebar">
    <img src="<?php echo e(asset('images/atjoin_logo.png')); ?>" alt="Company Logo">
    <h3>Dashboard</h3>
    <a href="<?php echo e(route('home.index')); ?>">🏠 Home</a>
    <a href="<?php echo e(route('quotationlist.index')); ?>">📜 Quotation List</a>
    <a href="<?php echo e(route('customer')); ?>" class="text-white">
      <i class="fas fa-user"></i> Customer Master
    </a>

  </div>

  <!-- Navbar -->
  <div class="navbar">
    <h4>Customer Master</h4>

  </div>

  <!-- Main Content -->
  <div class="content">
    <div class="container mt-5">
      <h2></h2>

      <!-- Success Message -->
      <?php if(session('success')): ?>
      <div class="alert alert-success text-center"><?php echo e(session('success')); ?></div>
      <?php endif; ?>

      <!-- Error Messages -->
      <?php if($errors->any()): ?>
      <div class="alert alert-danger">
        <ul>
          <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <li><?php echo e($error); ?></li>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
      </div>
      <?php endif; ?>
      <?php $__errorArgs = ['company_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
      <?php $__errorArgs = ['customer_name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
      <?php $__errorArgs = ['address'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <div class="text-danger"><?php echo e($message); ?></div> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>


      <!-- Customer Form -->
      <form action="<?php echo e(route('customer.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>

        <div class="row">
          <div class="col-md-6 mb-3">
            <label>Client Name</label>
            <input type="text" name="company_name" class="form-control" pattern="^[A-Za-z\s]+$"
              title="Only letters allowed, no spaces" placeholder="Please Enter Client Number">
          </div>
          <div class="col-md-6 mb-3">
            <label>Customer Name</label>
            <input type="text" name="customer_name" class="form-control" required pattern="^[A-Za-z\s]+$"
              title="Only letters and spaces allowed" placeholder="Please Enter Customer Number">
          </div>
          <div class="col-md-6 mb-3">
            <label>Contact</label>
            <input type="text" name="contact" class="form-control" required pattern="^[6-9]\d{9}$" maxlength="10"
              title="Must be a 10-digit number starting with 6 to 9" placeholder="Please Enter Contact Number">
          </div>
          <div class="col-md-6 mb-3">
            <label>GSTN</label>
            <input type="text" name="gst_number" id="gst_number" class="form-control"
              pattern="^[0-9]{2}[A-Z]{5}[0-9]{4}[A-Z]{1}[1-9A-Z]{1}Z[0-9A-Z]{1}$"
              title="Enter valid 15-digit GST number which is include State Code. PAN of the business. First registration under this PAN in Maharashtra.Reserved character.Checksum digit for error detection."
              placeholder="Please Enter Gst Number">
          </div>
          <div class="col-md-6 mb-3">
            <label>Email</label>
            <input type="email" name="email" class="form-control" placeholder="Please Enter Email" required>
          </div>
          <div class="col-md-6 mb-3">
            <label>Address</label>
            <input type="text" name="address" class="form-control" required pattern="^[A-Za-z0-9\s,./-]+$"
              title="Only letters, numbers, comma, dot, slash and dash allowed" placeholder="Please Enter Address">
          </div>
          <div class="col-md-6 mb-3">
            <label>City</label>
            <input type="text" name="city" class="form-control" required pattern="^[A-Za-z\s]+$"
              title="Only letters and spaces allowed" placeholder="Please Enter City">
          </div>

          <div class="col-md-6 mb-3">
            <label class="form-label">State</label>
            <select name="state" id="state" class="form-select" required>
              <option value="">Select State</option>
              <?php
              $states = [
              'Andaman and Nicobar Islands', 'Andhra Pradesh', 'Arunachal Pradesh', 'Assam',
              'Bihar', 'Chandigarh', 'Chhattisgarh', 'Dadra and Nagar Haveli and Daman and Diu',
              'Delhi', 'Goa', 'Gujarat', 'Haryana', 'Himachal Pradesh', 'Jammu and Kashmir',
              'Jharkhand', 'Karnataka', 'Kerala', 'Ladakh', 'Lakshadweep', 'Madhya Pradesh',
              'Maharashtra', 'Manipur', 'Meghalaya', 'Mizoram', 'Nagaland', 'Odisha',
              'Puducherry', 'Punjab', 'Rajasthan', 'Sikkim', 'Tamil Nadu', 'Telangana',
              'Tripura', 'Uttar Pradesh', 'Uttarakhand', 'West Bengal'
              ];
              sort($states);
              ?>

              <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option value="<?php echo e($state); ?>" <?php echo e(old('state') == $state ? 'selected' : ''); ?>>
                <?php echo e($state); ?>

              </option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <?php $__errorArgs = ['state'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <div class="text-danger"><?php echo e($message); ?></div>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
          </div>
        </div>
    </div>
    <div class="text-center">
      <button type="submit" class="btn btn-primary btn-lg mt-3">Add Customer</button>
    </div>
    </form>

    <!-- Customer List -->
    <h3 class="mt-5">Customer List</h3>
    <div class="table-responsive">
      <table class="table table-striped table-bordered">
        <thead>
          <tr>
            <th>Client Name</th>
            <th>Customer Name</th>
            <th>Contact</th>
            <th>GSTN</th>
            <th>Email</th>
            <th>Address</th>
            <th>City</th>
            <th>State</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($customer->company_name); ?></td>
            <td><?php echo e($customer->customer_name); ?></td>
            <td><?php echo e($customer->contact); ?></td>
            <td><?php echo e($customer->gst_number); ?></td>
            <td><?php echo e($customer->email); ?></td>
            <td><?php echo e($customer->address); ?></td>
            <td><?php echo e($customer->city); ?></td>
            <td><?php echo e($customer->state); ?></td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>
    </div>
    <div class="d-flex justify-content-center mt-3">
      <?php echo e($customers->links()); ?>

    </div>
  </div>
  </div>

  <script>
  document.addEventListener("DOMContentLoaded", function() {
    let customerNameInput = document.querySelector('input[name="customer_name"]');
    let contactInput = document.querySelector('input[name="contact"]');

    // Auto-capitalize first letter of the customer name
    customerNameInput.addEventListener("input", function() {
      let value = customerNameInput.value;
      customerNameInput.value = value.replace(/\b\w/g, char => char.toUpperCase());
    });

    // Allow only 10 digits in the contact field
    contactInput.addEventListener("input", function() {
      contactInput.value = contactInput.value.replace(/\D/g, "").slice(0, 10);
    });

    let gstInput = document.getElementById("gst_number");
    let stateDropdown = document.getElementById("state");

    const gstStateMap = {
      "01": "Jammu and Kashmir",
      "02": "Himachal Pradesh",
      "03": "Punjab",
      "04": "Chandigarh",
      "05": "Uttarakhand",
      "06": "Haryana",
      "07": "Delhi",
      "08": "Rajasthan",
      "09": "Uttar Pradesh",
      "10": "Bihar",
      "11": "Sikkim",
      "12": "Arunachal Pradesh",
      "13": "Nagaland",
      "14": "Manipur",
      "15": "Mizoram",
      "16": "Tripura",
      "17": "Meghalaya",
      "18": "Assam",
      "19": "West Bengal",
      "20": "Jharkhand",
      "21": "Odisha",
      "22": "Chhattisgarh",
      "23": "Madhya Pradesh",
      "24": "Gujarat",
      "25": "Daman and Diu",
      "26": "Dadra and Nagar Haveli",
      "27": "Maharashtra",
      "28": "Andhra Pradesh",
      "29": "Karnataka",
      "30": "Goa",
      "31": "Lakshadweep",
      "32": "Kerala",
      "33": "Tamil Nadu",
      "34": "Puducherry",
      "35": "Andaman and Nicobar Islands",
      "36": "Telangana",
      "37": "Andhra Pradesh",
      "38": "Ladakh"
    };

    gstInput.addEventListener("input", function() {
      const gstNumber = gstInput.value.trim();
      if (gstNumber.length >= 2) {
        const stateCode = gstNumber.substring(0, 2);
        const stateName = gstStateMap[stateCode];
        if (stateName) {
          for (let option of stateDropdown.options) {
            if (option.text.toLowerCase() === stateName.toLowerCase()) {
              option.selected = true;
              break;
            }
          }
        }
      }
    });
  });
  </script>

</body>

</html><?php /**PATH /home/mcndhanoreco/public_html/quotation.mcndhanore.co.in/my-quote/resources/views/customer.blade.php ENDPATH**/ ?>