<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Invoice</title>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
  <style>
  @font-face {
    font-family: 'DejaVu Sans';
    font-style: normal;
    font-weight: normal;
    src: url("<?php echo e(public_path('fonts/DejaVuSans.ttf')); ?>") format('truetype');
  }

  @page {
    margin: 2px;
    /* Keep small margins */
  }

  * {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
    font-family: 'DejaVu Sans', Arial, sans-serif;
  }

  body {
    font-family: 'DejaVu Sans', Arial, sans-serif;
    font-size: 12px;
    /* Increased by 20% */
    max-width: 80%;
  }

  .container {
    width: 100%;
    margin: 40px 140px;
    padding: 12px;
    /* Increased by 20% */
  }

  .header {
    text-align: center;
  }

  .header img {
    max-width: 120px;
    margin-bottom: 10px;
  }

  .billing-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 5px;
  }

  .billing-table th,
  .billing-table td {
    border: 1px #f2f2f2;
    padding: 6px;
    text-align: left;
    vertical-align: top;
    width: 50%;
  }

  .billing-table th {
    background-color: #f2f2f2;
    text-align: left;
    font-weight: bold;
  }

  /* Items Table */

  .table-container {
    width: 100%;
    border-collapse: collapse;
    margin-top: 6px;
    /* Increased */
  }

  .table-container th {
    background-color: #f2f2f2;
  }

  table,
  th {
    border: 1px solid black;
    text-align: center;
    padding: 6px;
  }

  .summary-table {
    width: 100%;
    border-collapse: collapse;
    margin-top: 6px;
  }

  .summary-table th {
    background-color: #f2f2f2;
    text-align: center;
    padding: 6px;
  }

  /* Footer Section */

  .btn {
    display: inline-block;
    padding: 10px 20px;
    font-size: 16px;
    font-weight: bold;
    text-align: center;
    text-decoration: none;
    color: white;
    background-color: #007bff;
    border: none;
    border-radius: 5px;
    transition: background 0.3s ease;
    margin-top: 20px;
  }

  .btn:hover {
    background-color: #0056b3;
  }

  .footer {
    display: flex;
    justify-content: center;
    margin-top: 20px;
  }

  .footer-table {
    width: 100%;
    border-collapse: collapse;
  }

  .footer-table th,
  .footer-table td {
    border: 1px #f2f2f2;
    padding: 6px;
    /* Increased */
    text-align: center;
    vertical-align: top;
  }

  .footer-table th {
    background-color: #f2f2f2;
    text-align: center;
    font-weight: bold;
  }

  .signature-box {
    text-align: center;
    padding-top: 24px;
    /* Increased */
  }

  /* Total Amount in Words */

  .total-words {
    margin-top: 6px;
    font-weight: bold;
    font-size: 15px;
    /* Increased */
  }
  </style>
</head>

<body>

  <form action="<?php echo e(route('invoice.store', ['quotationId' => $quotation->id])); ?>" method="POST">
    <?php echo csrf_field(); ?>

    <div class="container">

      <!-- Header -->
      <table class="header" style="width: 100%; border-collapse: collapse; font-size: 12px;">
        <tr>
          <!-- Logo Left -->
          <td style="width: 33%; text-align: left; vertical-align: middle; padding: 10px;">
            <?php $path = public_path('images/atjoin_logo.png'); $type = pathinfo($path, PATHINFO_EXTENSION); $data =
            file_get_contents($path); $base64 = 'data:image/' . $type . ';base64,' . base64_encode($data); ?>
            <img src="<?php echo e($base64); ?>" alt="Logo" width="100">
          </td>

          <!-- Company Name Center -->
          <td style="width: 34%; text-align: center; vertical-align: middle;">
            <strong style="font-size: 16px;">ATJOIN PVT. LTD</strong><br>
            <span style="font-size: 12px;">Sanewadi, Aundh, Pune, Maharashtra 411007</span>
          </td>

          <!-- Quotation Details Right -->
          <td style="width: 33%; text-align: left; vertical-align: middle; padding-left: 230px; margin-left:20px;">
            <strong>Invoice No:</strong> <?php echo e($invoiceNumber); ?><br>
            <strong>Date:</strong> <?php echo e($invoiceDate); ?>

          </td>
        </tr>
      </table>
      <!-- Bill To & Ship To -->
      <table class="billing-table">
        <tr>
          <th>Invoice From</th>
          <th>Invoice To</th>
        </tr>
        <tr>
          <td>
            <strong>ATJOIN PVT. LTD</strong><br> 5th Floor, Luv-Kush Apt.<br> Seasons Business Center,<br> Opp. Kothari
            Hyundai Showroom,<br> Sanewadi, Aundh, Pune, Maharashtra 411007
            <p><strong>GSTN:</strong>27AAWCA2027J1ZE </p>

          </td>
          <td>
            <strong>Client Name:</strong> <?php echo e($quotation->company_name); ?><br />
            <strong>Customer Name:</strong> <?php echo e($quotation->customer_name); ?><br />
            <strong>Address:</strong> <?php echo e($quotation->address); ?><br />
            <strong>Contact:</strong> <?php echo e($quotation->contact); ?><br />
            <strong>Email:</strong> <?php echo e($quotation->email); ?><br />
            <strong>GSTN:</strong> <?php echo e($quotation->gst_number); ?>

          </td>
        </tr>
      </table>

      <!-- Items Table -->
      <table class="table-container">
        <tr>
          <th style="width:50px;">Sr No</th>
          <th>Items</th>
          <th style="width:100px;">HSN</th>
          <th style="width:100px;">Qty</th>
          <th style="width:100px;">Unit Price</th>
          <th style="width:100px;">Amount</th>
        </tr>
        <?php $__currentLoopData = $quotationitems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
          <td style=" border-left: 1px solid black; border-right: 1px solid black; text-align:left; padding-left:5px;">
            <?php echo e($item->sr_no); ?></td>
          <td style=" border-left: 1px solid black; border-right: 1px solid black; text-align:left; padding-left:5px;">
            <?php echo e($item->description); ?></td>
          <td style="border-left: 1px solid black; border-right: 1px solid black; padding: 1px; line-height: 1;">
            <?php echo e($quotation->hsn_number); ?></td>
          <td style=" border-left: 1px solid black; border-right: 1px solid black;"><?php echo e($item->quantity); ?>

            </>
          <td
            style=" border-left: 1px solid black; border-right: 1px solid black; text-align:right; padding-right:5px;">₹
            <?php echo e(number_format($item->amount, 2)); ?></td>
          <td
            style=" border-left: 1px solid black; border-right: 1px solid black; text-align:right; padding-right:5px;">₹
            <?php echo e(number_format($item->total_amount, 2)); ?>

          </td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        <tr>

          <td colspan="6"
            style="border: 1px solid black; border-left: 1px solid black;  text-align: right; padding-right:5px;">
            <strong>CGST:</strong> ₹<?php echo e(number_format($quotation->cgst, 2)); ?><br>
            <strong>SGST:</strong> ₹<?php echo e(number_format($quotation->sgst, 2)); ?><br>
          </td>

        </tr>
        <tr>
          <td colspan="6" style="border: 1px solid black; padding: 10px; text-align: right;">

            <strong>Total:</strong> ₹<?php echo e(number_format($quotation->grand_total, 2)); ?>

          </td>
        </tr>
      </table>

      <div class="row justify-content-end">
        <div class="col-md-4">
          <div class="total-section" style="float: right; width: 200px; margin-top: 10px;">
            <h4>Subtotal: ₹ <?php echo e(number_format($quotation->subtotal, 2)); ?></h4>

            <input type="hidden" id="hiddenGrandTotal" value="<?php echo e($quotation->grand_total); ?>">
            <input type="hidden" id="hiddenBalanceDue" name="balance_due" value="<?php echo e($quotation->grand_total); ?>">

            <label for="discount"><strong>Discount (%):</strong></label>
            <input type="number" id="discount" name="discount" class="form-control" oninput="updateBalanceDue()"
              value="0" min="0" max="100" step="0.01" />

            <h4 class="mt-3">Balance Due:
              <span id="balanceDue">₹ <?php echo e(number_format($quotation->grand_total, 2)); ?></span>
            </h4>
          </div>
        </div>
      </div>

      <!-- Summary Table -->
      <?php
      $isMaharashtra = isset($quotation) && strtolower($quotation->state) === 'maharashtra';
      ?>

      <table class="table table-bordered mb-3" style="width:100%; margin-top:6px;">
        <tr>
          <th>HSN/SAC</th>
          <th>Taxable Value</th>
          <?php if($isMaharashtra): ?>
          <th colspan="2">CGST</th>
          <th colspan="2">SGST</th>
          <th colspan="2" class="text-muted">IGST</th>
          <?php else: ?>
          <th colspan="2" class="text-muted">CGST</th>
          <th colspan="2" class="text-muted">SGST</th>
          <th colspan="2">IGST</th>
          <?php endif; ?>
          <th>Total Tax Amount</th>
        </tr>

        <tr>
          <th></th>
          <th></th>
          <?php if($isMaharashtra): ?>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <th class="text-muted">Rate (%)</th>
          <th class="text-muted">Amount (₹)</th>
          <?php else: ?>
          <th class="text-muted">Rate (%)</th>
          <th class="text-muted">Amount (₹)</th>
          <th class="text-muted">Rate (%)</th>
          <th class="text-muted">Amount (₹)</th>
          <th>Rate (%)</th>
          <th>Amount (₹)</th>
          <?php endif; ?>
          <th></th>
        </tr>

        <tr>
          <td><?php echo e($quotation->hsn_number); ?></td>
          <td><?php echo e(number_format($quotation->gst_rate, 2)); ?>%</td>

          <?php if($isMaharashtra): ?>
          <td><?php echo e($gst_rate / 2); ?>%</td>
          <td>₹<?php echo e(number_format($cgst, 2)); ?></td>
          <td><?php echo e($gst_rate / 2); ?>%</td>
          <td>₹<?php echo e(number_format($sgst, 2)); ?></td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <?php else: ?>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td><?php echo e($quotation->gst_rate); ?>%</td>
          <td>₹<?php echo e(number_format($quotation->igst, 2)); ?></td>
          <?php endif; ?>

          <td>
            <?php if($isMaharashtra): ?>
            ₹<?php echo e(number_format($cgst + $sgst, 2)); ?>

            <?php else: ?>
            ₹<?php echo e(number_format($quotation->igst, 2)); ?>

            <?php endif; ?>
          </td>
        </tr>

        <tr>
          <td><strong>Total:</strong></td>
          <td><strong><?php echo e(number_format($quotation->gst_rate, 2)); ?>%</strong></td>

          <?php if($isMaharashtra): ?>
          <td><strong><?php echo e($gst_rate / 2); ?>%</strong></td>
          <td><strong>₹<?php echo e(number_format($cgst, 2)); ?></strong></td>
          <td><strong><?php echo e($quotation->gst_rate / 2); ?>%</strong></td>
          <td><strong>₹<?php echo e(number_format($sgst, 2)); ?></strong></td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <?php else: ?>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td class="text-muted">—</td>
          <td><strong><?php echo e($quotation->gst_rate); ?>%</strong></td>
          <td><strong>₹<?php echo e(number_format($quotation->igst, 2)); ?></strong></td>
          <?php endif; ?>

          <td>
            <strong>
              <?php if($isMaharashtra): ?>
              ₹<?php echo e(number_format($cgst + $sgst, 2)); ?>

              <?php else: ?>
              ₹<?php echo e(number_format($quotation->igst, 2)); ?>

              <?php endif; ?>
            </strong>
          </td>
        </tr>
      </table>



      <!-- Footer -->
      <div class="footer">
        <table class="footer-table">
          <tr>
            <th style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">Bank Details</th>
            <th style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">Terms and Conditions
            </th>
            <th style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">Authorized Signature
            </th>
          </tr>
          <tr>
            <td style="border-left: 1px solid black; border-right: 1px solid black; text-align:left; padding: 10px;">
              <strong>Name:</strong> ATJOIN PRIVATE LIMITED<br>
              <strong>IFSC Code:</strong>MAHB0000277<br>
              <strong>Account No:</strong> 60402360743<br>
              <strong>Bank:</strong> Bank of Maharashtra
            </td>
            <td style="border-left: 1px solid black; border-right: 1px solid black; text-align:left; padding: 10px;">
              1. Payment due within 15 days.<br> 2. Overdue interest at <?php echo e($quotation->gst_rate); ?> will be <br>charged on
              delayed payments.
            </td>
            <td class="signature-box"
              style="border-left: 1px solid black; border-right: 1px solid black; padding: 10px;">
              (Sign & Stamp)
            </td>
          </tr>
        </table>
      </div>


      <button type=" submit" class="btn">
        Invoice Pdf <i class="fas fa-download me-1"></i>
      </button>

    </div>

  </form>
  </div>


  <script>
  function updateBalanceDue() {
    let grandTotal = parseFloat(document.getElementById("hiddenGrandTotal").value) || 0;

    let discountPercent = parseFloat(document.getElementById("discount").value) || 0;
    let discountAmount = (grandTotal * discountPercent) / 100;

    let balanceDue = grandTotal - discountAmount;

    document.getElementById("balanceDue").innerText = "₹ " + balanceDue.toFixed(2);
    document.getElementById("hiddenBalanceDue").value = balanceDue.toFixed(2);
  }
  </script>

</body>

</html><?php /**PATH D:\xampp\htdocs\quotation-builder\resources\views\quotationlist\invoice.blade.php ENDPATH**/ ?>