<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Quotation</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <style>
  .container {
    margin-top: 20px;
  }

  .summary p {
    font-weight: bold;
  }
  </style>
</head>

<body>
  <div class="container">
    <h2>Edit Quotation</h2>
    <form action="<?php echo e(route('quotationlist.update', $quotation->id)); ?>" method="POST">
      <?php echo csrf_field(); ?>
      <?php echo method_field('PUT'); ?>

      <input type="hidden" id="customer_state" name="customer_state" value="<?php echo e($quotation->customer_state); ?>">


      <div class="mb-3">
        <label>Quotation Number:</label>
        <input type="text" name="quotation_number" value="<?php echo e($quotation->quotation_number); ?>" class="form-control"
          required>
      </div>

      <div class="mb-3">
        <label>Customer Name:</label>
        <input type="text" name="customer_name" value="<?php echo e($quotation->customer_name); ?>" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Quotation Date:</label>
        <input type="date" name="quotation_date" value="<?php echo e($quotation->quotation_date); ?>" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>GST Rate (%):</label>
        <input type="number" id="gst_rate" name="gst_rate" value="<?php echo e($quotation->gst_rate); ?>" class="form-control"
          required>
      </div>
      <div class="mb-3">
        <label>GST Type:</label>
        <input id="gst_type" name="gst_type" value="<?php echo e($quotation->gst_type); ?>" class="form-control" required readonly>
      </div>

      <table class="table" id="itemsTable">
        <thead>
          <tr>
            <th>Sr No</th>
            <th>Item Description</th>
            <th>Qty</th>
            <th>Price</th>
            <th>Total Amount</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          <?php $__currentLoopData = $quotationitems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <input type="hidden" name="items[<?php echo e($index); ?>][id]" value="<?php echo e($item->id); ?>">
            <td>
              <input type="number" name="items[<?php echo e($index); ?>][sr_no]" value="<?php echo e($item->sr_no ?? $index + 1); ?>"
                class="form-control" required>
            </td>

            <td><input type="text" name="items[<?php echo e($index); ?>][description]" class="form-control"
                value="<?php echo e($item->description); ?>" required></td>
            <td><input type="number" name="items[<?php echo e($index); ?>][quantity]" class="form-control quantity"
                value="<?php echo e($item->quantity); ?>" required></td>
            <td><input type="number" name="items[<?php echo e($index); ?>][price]" class="form-control price"
                value="<?php echo e($item->amount); ?>" required></td>
            <td><input type="text" name="items[<?php echo e($index); ?>][total]" class="form-control total"
                value="<?php echo e($item->total_amount); ?>" readonly></td>
            <td><button type="button" class="btn btn-danger remove-item">X</button></td>
          </tr>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
      </table>

      <button type="button" id="addItem" class="btn btn-primary">Add Item</button>

      <div class="summary mt-3">
        <p><strong>Sub Total:</strong> ₹<span id="subtotal">0</span></p>
        <p><strong>CGST:</strong> ₹<span id="cgst">0</span></p>
        <p><strong>SGST:</strong> ₹<span id="sgst">0</span></p>
        <p><strong>IGST:</strong> ₹<span id="igst">0</span></p>
        <p><strong>Grand Total:</strong> ₹<span id="grand_total">0</span></p>

        <input type="hidden" name="subtotal_value" id="subtotal_value">
        <input type="hidden" name="cgst_value" id="cgst_value">
        <input type="hidden" name="sgst_value" id="sgst_value">
        <input type="hidden" name="igst_value" id="igst_value">
        <input type="hidden" name="grand_total_value" id="grand_total_value">

      </div>

      <button type="submit" class="btn btn-success">Update Quotation</button>
    </form>
  </div>

  <script>
  document.addEventListener("DOMContentLoaded", function() {
    function calculateTotals() {
      let subtotal = 0;
      document.querySelectorAll(".total").forEach(input => {
        subtotal += parseFloat(input.value) || 0;
      });

      const gstRate = parseFloat(document.getElementById("gst_rate").value) || 0;
      const gstType = document.getElementById("gst_type").value;
      const customerState = document.getElementById("customer_state").value.toLowerCase();
      const companyState = "maharashtra"; // Set your actual company state here

      let cgst = 0,
        sgst = 0,
        igst = 0,
        grandTotal = 0;

      if (gstType === "excluding") {
        gstTotal = (subtotal * gstRate) / 100;
        grandTotal = subtotal + gstTotal;
      } else {
        gstTotal = subtotal - (subtotal / (1 + gstRate / 100));
        grandTotal = subtotal;
        subtotal = subtotal - gstTotal;
      }

      const isIntraState = (customerState === companyState.toLowerCase());

      if (isIntraState) {
        cgst = sgst = gstTotal / 2;
        igst = 0;
        grandTotal = subtotal + cgst + sgst;
      } else {
        cgst = sgst = 0;
        igst = gstTotal;
        grandTotal = subtotal + igst;
      }


      document.getElementById("subtotal").innerText = subtotal.toFixed(2);
      document.getElementById("cgst").innerText = cgst.toFixed(2);
      document.getElementById("sgst").innerText = sgst.toFixed(2);
      document.getElementById("igst").innerText = igst.toFixed(2);
      document.getElementById("grand_total").innerText = grandTotal.toFixed(2);

      // Set hidden values for form submission
      document.getElementById("subtotal_value").value = subtotal.toFixed(2);
      document.getElementById("cgst_value").value = cgst.toFixed(2);
      document.getElementById("sgst_value").value = sgst.toFixed(2);
      document.getElementById("igst_value").value = igst.toFixed(2);
      document.getElementById("grand_total_value").value = grandTotal.toFixed(2);
    }


    document.querySelector("#itemsTable").addEventListener("input", function(event) {
      if (event.target.classList.contains("quantity") || event.target.classList.contains("price")) {
        let row = event.target.closest("tr");
        let quantity = parseFloat(row.querySelector(".quantity").value) || 0;
        let price = parseFloat(row.querySelector(".price").value) || 0;
        let total = quantity * price;
        row.querySelector(".total").value = total.toFixed(2);
        calculateTotals();
      }
    });

    document.getElementById("addItem").addEventListener("click", function() {
      let rowCount = document.querySelectorAll("#itemsTable tbody tr").length;
      let newRow = `
        <tr>
           <td><input type="number" name="items[${rowCount}][sr_no]"  class="form-control" required></td>
          <td><input type="text" name="items[${rowCount}][description]" class="form-control" required></td>
          <td><input type="number" name="items[${rowCount}][quantity]" class="form-control quantity" required></td>
          <td><input type="number" name="items[${rowCount}][price]" class="form-control price" required></td>
          <td><input type="text" name="items[${rowCount}][total]" class="form-control total" readonly></td>
          <td><button type="button" class="btn btn-danger remove-item">X</button></td>
        </tr>`;
      document.querySelector("#itemsTable tbody").insertAdjacentHTML("beforeend", newRow);
    });

    document.querySelector("#itemsTable").addEventListener("click", function(event) {
      if (event.target.classList.contains("remove-item")) {
        event.target.closest("tr").remove();
        calculateTotals();
      }
    });

    document.getElementById("gst_rate").addEventListener("input", calculateTotals);
    document.getElementById(
      "gst_type").addEventListener("change", calculateTotals);

    calculateTotals(); // Initial call
  });
  </script>

</body>

</html><?php /**PATH /home/mcndhanoreco/public_html/quotation.mcndhanore.co.in/my-quote/resources/views/quotationlist/edit.blade.php ENDPATH**/ ?>