<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Items Page</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
  <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.17.0/xlsx.full.min.js"></script>
</head>
<style>
body {
  background-color: #f0f2f5;
  overflow-x: hidden;
}

.sidebar {
  width: 250px;
  background: linear-gradient(135deg, #2c3e50, #2a5298);
  padding: 20px;
  color: white;
  height: 100vh;
  position: fixed;
  left: 0;
  top: 0;
}

.sidebar img {
  width: 100px;
  margin-bottom: 20px;
}

.sidebar a {
  color: white;
  display: block;
  padding: 10px;
  margin: 10px 0;
  border-radius: 5px;
  transition: 0.3s;
  text-decoration: none;
}

.sidebar a:hover {
  background-color: rgba(255, 255, 255, 0.1);
}

.navbar {
  margin-left: 250px;
  background: linear-gradient(135deg, #2a5298, #1e3c72);
  padding: 15px;
  color: white;
  position: fixed;
  top: 0;
  width: calc(100% - 250px);
  justify-content: center;
  text-align: center;
}

.content {
  margin-left: 250px;
  margin-top: 80px;
  padding: 20px;
}

.form-section {
  background-color: white;
  border-radius: 12px;
  padding: 25px;
  box-shadow: 0 0 15px rgba(0, 0, 0, 0.05);
  width: 83%;
}

.table thead th {
  background-color: #1e3c72;
  color: white;
  text-align: center;
}

.table input {
  text-align: center;
}

.totals p {
  font-weight: 500;
  font-size: 16px;
}

@media (max-width: 768px) {
  .sidebar {
    width: 200px;
  }

  .navbar {
    width: calc(100% - 200px);
  }

  .content {
    margin-left: 200px;
  }
}
</style>

<body>
  <div class=" sidebar">
    <img src="<?php echo e(asset('images/atjoin_logo.png')); ?>" alt="Company Logo">
    <h3>Dashboard</h3>
    <a href="<?php echo e(route('home.index')); ?>">🏠 Home</a>
    <a href="<?php echo e(route('quotationlist.index')); ?>">📜 Quotation List</a>
    <a href="<?php echo e(route('customer')); ?>" class="text-white">
      <i class="fas fa-user"></i> Customer Master
    </a>
  </div>

  <!-- Navbar -->
  <div class="navbar">
    <h4 class="m-0">Items Page</h4>
  </div>

  <div class="content container-fluid">
    <div class="form-section">



      <div id="gstModal" class="modal" style="padding-top:170px; width:90%; padding-left:30%; text-align:center; ">
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
          <span class=" close-btn">&times;</span>
          <p>Please choose GST type.</p>
        </div>
      </div>




      <?php if(session('success')): ?>
      <div class="alert alert-success"><?php echo e(session('success')); ?></div>
      <?php endif; ?>

      <div class="mb-4 ">
        <label class="form-label fw-bold">Upload Excel:</label>
        <label for="uploadExcel" class="btn btn-outline-primary btn-sm ms-2">
          <i class="fas fa-upload me-1"></i>Select File
          <input type="file" id="uploadExcel" hidden onchange="handleFileUpload(event)">
        </label>

        <a href="<?php echo e(asset('sample_items.xlsx')); ?>" download class="btn btn-outline-success btn-sm">
          <i class="fas fa-download me-1"></i>Download Sample
        </a>
      </div>
      <form action="<?php echo e(route('items.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>


        <div class="col-md-6">
          <?php
          $selectedCustomer = App\Models\SelectCustomer::first();
          $customerState = $selectedCustomer ? $selectedCustomer->state : '';
          ?>

          <?php if($selectedCustomer): ?>
          <input type="hidden" id="customer-state" name="customer_state" value="<?php echo e($customerState); ?>">
          <?php endif; ?>
        </div>
        <input type="hidden" name="customer_id" value="<?php echo e(session('selected_customer.customer_id')); ?>">

        <!-- GST Options -->
        <div class="row mb-4">
          <div class="col-md-6">
            <label class="form-label">GST Type:</label>
            <div class="form-check">
              <input class="form-check-input" type="radio" name="gst_type" value="excluding" id="excluding_gst"
                onclick="updateTotals()">

              <label class="form-check-label" for="excluding_gst">Excluding GST</label>
            </div>
            <div class="form-check">
              <input class="form-check-input" type="radio" name="gst_type" value="including" id="including_gst"
                onclick="updateTotals()">

              <label class="form-check-label" for="including_gst">Including GST</label>
            </div>
          </div>

          <?php if($errors->has('gst_type')): ?>
          <!-- GST Type Modal -->
          <div class="modal fade" id="gstTypeModal" tabindex="-1" aria-labelledby="gstTypeModalLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
              <div class="modal-content">

                <h5 class="modal-title" id="gstTypeModalLabel">Validation Error</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                <div class="modal-body">
                  <?php echo e($errors->first('gst_type')); ?>

                </div>
                <div class="modal-footer">
                  <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">OK</button>
                </div>
              </div>
            </div>
          </div>
          <?php endif; ?>



          <div class="col-md-6">
            <label class="form-label">GST Rate:</label>
            <div class="d-flex flex-wrap gap-3">
              <div class="form-check">
                <input class="form-check-input" type="radio" name="gst_rate" value="5" id="gst_5"
                  onclick="updateTotals()">
                <label class="form-check-label" for="gst_5">5%</label>
              </div>
              <div class="form-check">
                <input class="form-check-input" type="radio" name="gst_rate" value="12" id="gst_12"
                  onclick="updateTotals()">
                <label class="form-check-label" for="gst_12">12%</label>
              </div>
              <div class="form-check">
                <input class="form-check-input" type="radio" name="gst_rate" value="18" id="gst_18"
                  onclick="updateTotals()" checked>
                <label class="form-check-label" for="gst_18">18%</label>
              </div>
              <div class="form-check">
                <input class="form-check-input" type="radio" name="gst_rate" value="28" id="gst_28"
                  onclick="updateTotals()">
                <label class="form-check-label" for="gst_28">28%</label>
              </div>
            </div>
          </div>
        </div>


        <datalist id="descriptionSuggestions">
          <option value="Computer">
          <option value="Item">
          <option value="Mouse">
          <option value="Keyboard">
          <option value="Monitor">
          <option value="Printer">
          <option value="Scanner">
          <option value="Laptop">
          <option value="Tablet">
          <option value="Smartphone">
          <option value="Headphones">
          <option value="Speaker">
          <option value="Webcam">
          <option value="Microphone">

        </datalist>

        <!-- Items Table -->
        <div class="table-responsive-sm">
          <table class="table table-bordered" id="excelTable">
            <thead>
              <tr>
                <th>Sr No</th>
                <th>Description</th>
                <th>Quantity</th>
                <th>Price</th>
                <th>Total Amount</th>
              </tr>
            </thead>
            <tbody>

            </tbody>
          </table>
        </div>


        <!-- Totals Section -->
        <div class="totals text-end mb-4">
          <p>Sub Total: <span id="sub_total">0</span></p>
          <p>CGST (<span id="CGST_percent"></span>%): <span id="CGST">0</span></p>
          <p>SGST (<span id="SGST_percent"></span>%): <span id="SGST">0</span></p>
          <p>IGST (<span id="IGST_percent"></span>%): <span id="IGST">0</span></p>
          <h5>Grand Total: ₹ <span id="Grand_Total">0</span></h5>
        </div>

        <!-- Buttons -->
        <div class="d-flex justify-content-between">
          <div>
            <button type="button" class="btn btn-outline-info" onclick="addManualRow()">
              <i class="fas fa-plus me-1"></i>Add Row
            </button>
          </div>
          <div>
            <a href="#" class="btn btn-secondary me-2">Back</a>
            <button type="submit" class="btn btn-success">
              <i class="fas fa-check-circle me-1"></i>Proceed to Quotation
            </button>


          </div>
        </div>
      </form>
    </div>


    <script>
    function handleFileUpload(event) {
      const file = event.target.files[0];
      if (!file) return;

      const reader = new FileReader();
      reader.onload = function(e) {
        const data = new Uint8Array(e.target.result);
        const workbook = XLSX.read(data, {
          type: "array"
        });
        const sheet = workbook.Sheets[workbook.SheetNames[0]];
        const jsonData = XLSX.utils.sheet_to_json(sheet, {
          header: 1
        });

        let tableBody = document.querySelector("#excelTable tbody");
        tableBody.innerHTML = "";

        for (let i = 1; i < jsonData.length; i++) {
          let row = jsonData[i];
          if (row.length < 3) continue;

          let description = row[0] || "";
          let quantity = row[1] || 0;
          let price = row[2] || 0;
          let total = (quantity * price).toFixed(2);

          let newRow = `
        <tr>
            <td><input type="text" name="data[${i}][sr_no]" class="form-control" value="${i}" readonly></td>
          <td><input type="text" name="data[${i}][description]" class="form-control" value="${description}" readonly></td>
          <td><input type="number" name="data[${i}][quantity]" class="form-control qty" value="${quantity}" readonly></td>
          <td><input type="number" name="data[${i}][amount]" class="form-control price" value="${price}" readonly></td>
          <td><input type="number" name="data[${i}][total_amount]" class="form-control total-amount" value="${total}" readonly></td>
        </tr>
      `;
          tableBody.innerHTML += newRow;
        }
        updateTotals();
      };
      reader.readAsArrayBuffer(file);
    }

    const suggestions = [
      "Computer", "Item", "Mouse", "Keyboard", "Monitor",
      "Printer", "Scanner", "Laptop", "Tablet",
      "Smartphone", "Headphones", "Speaker", "Webcam", "Microphone"
    ];

    function filterSuggestions(input) {
      let container = input.parentElement;
      let list = container.querySelector(".suggestion-list");
      let value = input.value.toLowerCase();
      list.innerHTML = "";

      if (value.length === 0) {
        list.style.display = "none";
        return;
      }

      let filtered = suggestions.filter(item => item.toLowerCase().includes(value));

      if (filtered.length === 0) {
        list.style.display = "none";
        return;
      }

      filtered.forEach(item => {
        let li = document.createElement("li");
        li.textContent = item;
        li.style.padding = "5px";
        li.style.cursor = "pointer";
        li.addEventListener("click", () => {
          input.value = item;
          list.style.display = "none";
        });
        list.appendChild(li);
      });

      list.style.display = "block";
    }

    document.addEventListener("click", function(e) {
      if (!e.target.closest(".dropdown-container")) {
        document.querySelectorAll(".suggestion-list").forEach(list => {
          list.style.display = "none";
        });
      }
    });

    function addManualRow() {
      let tableBody = document.querySelector("#excelTable tbody");
      let rowCount = tableBody.rows.length;

      let newRow = document.createElement("tr");
      newRow.innerHTML = `
      <td><input type="text" name="data[${rowCount}][sr_no]" class="form-control" value="${rowCount + 1}" readonly></td>
      <td>
        <div class="dropdown-container" style="position: relative;">
          <input type="text" name="data[${rowCount}][description]" class="form-control description-input" oninput="filterSuggestions(this)">
          <ul class="suggestion-list" style="list-style: none; padding: 0; margin: 0; position: absolute; background: white; border: 1px solid #ccc; z-index: 1000; display: none; max-height: 120px; overflow-y: auto;"></ul>
        </div>
      </td>
      <td><input type="number" name="data[${rowCount}][quantity]" class="form-control qty" oninput="calculateTotal(this)"></td>
      <td><input type="number" name="data[${rowCount}][amount]" class="form-control price" oninput="calculateTotal(this)"></td>
      <td><input type="number" name="data[${rowCount}][total_amount]" class="form-control total-amount" readonly></td>
    `;

      tableBody.appendChild(newRow);
    }


    document.querySelector("form").addEventListener("submit", function(e) {
      const gstType = document.querySelector("[name='gst_type']:checked");
      if (!gstType) {
        e.preventDefault();

        // Show the custom popup
        document.getElementById("gstModal").style.display = "block";

        // Save current form data to localStorage
        let tableRows = [];
        document.querySelectorAll("#excelTable tbody tr").forEach(row => {
          let sr_no = row.querySelector('[name*="[sr_no]"]').value;
          let description = row.querySelector('[name*="[description]"]').value;
          let qty = row.querySelector('[name*="[quantity]"]').value;
          let price = row.querySelector('[name*="[amount]"]').value;
          let total = row.querySelector('[name*="[total_amount]"]').value;

          tableRows.push({
            sr_no,
            description,
            qty,
            price,
            total
          });
        });

        localStorage.setItem("temp_excel_data", JSON.stringify(tableRows));
      }
    });

    // Close the modal
    document.querySelector(".close-btn").addEventListener("click", function() {
      document.getElementById("gstModal").style.display = "none";
    });

    // Optional: Close if clicked outside the modal content
    window.addEventListener("click", function(event) {
      const modal = document.getElementById("gstModal");
      if (event.target === modal) {
        modal.style.display = "none";
      }
    });


    function calculateTotal(element) {
      let row = element.closest("tr");
      let qty = parseFloat(row.querySelector(".qty").value) || 0;
      let price = parseFloat(row.querySelector(".price").value) || 0;
      let totalField = row.querySelector(".total-amount");

      let total = qty * price;
      totalField.value = total.toFixed(2);

      updateTotals();
    }

    function updateTotals() {
      let subtotal = 0;
      document.querySelectorAll(".total-amount").forEach(input => {
        subtotal += parseFloat(input.value) || 0;
      });

      const customerState = document.getElementById("customer-state")?.value.trim().toLowerCase();
      const companyState = "maharashtra"; // Set your company’s state here

      let gstType = document.querySelector('input[name="gst_type"]:checked')?.value || "excluding";
      let gstRate = parseFloat(document.querySelector('input[name="gst_rate"]:checked')?.value) || 0;
      let gstTotal, cgst, sgst, grandTotal, igst;

      if (gstType === "excluding") {
        gstTotal = (subtotal * gstRate) / 100;
        grandTotal = subtotal + gstTotal;
      } else {
        gstTotal = subtotal - (subtotal / (1 + gstRate / 100));
        grandTotal = subtotal;
        subtotal = subtotal - gstTotal;
      }

      const isIntraState = (customerState === companyState.toLowerCase());

      if (isIntraState) {
        cgst = sgst = gstTotal / 2;
        igst = 0;

        document.getElementById("CGST").textContent = cgst.toFixed(2);
        document.getElementById("SGST").textContent = sgst.toFixed(2);
        document.getElementById("IGST").textContent = "0";

        document.getElementById("CGST_percent").textContent = (gstRate / 2).toFixed(2);
        document.getElementById("SGST_percent").textContent = (gstRate / 2).toFixed(2);
        document.getElementById("IGST_percent").textContent = "0";

      } else {
        cgst = sgst = 0;
        igst = gstTotal;

        document.getElementById("CGST").textContent = "0";
        document.getElementById("SGST").textContent = "0";
        document.getElementById("IGST").textContent = igst.toFixed(2);

        document.getElementById("CGST_percent").textContent = "0";
        document.getElementById("SGST_percent").textContent = "0";
        document.getElementById("IGST_percent").textContent = gstRate.toFixed(2);
      }

      // let halfGstRate = gstRate / 2;
      // document.getElementById("CGST_percent").textContent = halfGstRate;
      // document.getElementById("SGST_percent").textContent = halfGstRate;

      document.getElementById("sub_total").textContent = subtotal.toFixed(2);
      document.getElementById("CGST").textContent = cgst.toFixed(2);
      document.getElementById("SGST").textContent = sgst.toFixed(2);
      document.getElementById("Grand_Total").textContent = grandTotal.toFixed(2);
    }
    document.getElementById("sub_total").textContent = subtotal.toFixed(2);
    document.getElementById("Grand_Total").textContent = grandTotal.toFixed(2);

    // if (gstApplication === "igst") {
    //   igst = gstTotal;
    //   document.getElementById("igst_row").style.display = "block";
    //   document.getElementById("CGST").textContent = "0.00";
    //   document.getElementById("SGST").textContent = "0.00";
    //   document.getElementById("CGST_percent").textContent = "0";
    //   document.getElementById("SGST_percent").textContent = "0";

    //   document.getElementById("IGST").textContent = igst.toFixed(2);
    //   document.getElementById("IGST_percent").textContent = gstRate;
    // } else {
    //   cgst = sgst = gstTotal / 2;
    //   document.getElementById("igst_row").style.display = "none";

    //   document.getElementById("CGST").textContent = cgst.toFixed(2);
    //   document.getElementById("SGST").textContent = sgst.toFixed(2);
    //   document.getElementById("CGST_percent").textContent = (gstRate / 2);
    //   document.getElementById("SGST_percent").textContent = (gstRate / 2);

    //   document.getElementById("IGST").textContent = "0.00";
    //   document.getElementById("IGST_percent").textContent = "0";
    // }

    document.querySelectorAll('input[name="gst_type"], input[name="gst_rate"]').forEach(radio => {
      radio.addEventListener('change', updateTotals);
    });

    function restoreData() {
      let storedData = localStorage.getItem("temp_excel_data");
      if (!storedData) return;

      let tableBody = document.querySelector("#excelTable tbody");
      tableBody.innerHTML = "";

      let rows = JSON.parse(storedData);

      rows.forEach((row, i) => {
        let newRow = `
      <tr>
        <td><input type="text" name="data[${i}][sr_no]" class="form-control" value="${row.sr_no}" readonly></td>
        <td>
          <div class="dropdown-container" style="position: relative;">
            <input type="text" name="data[${i}][description]" class="form-control description-input" value="${row.description}" oninput="filterSuggestions(this)">
            <ul class="suggestion-list" style="list-style: none; padding: 0; margin: 0; position: absolute; background: white; border: 1px solid #ccc; z-index: 1000; display: none; max-height: 120px; overflow-y: auto;"></ul>
          </div>
        </td>
        <td><input type="number" name="data[${i}][quantity]" class="form-control qty" value="${row.qty}" oninput="calculateTotal(this)"></td>
        <td><input type="number" name="data[${i}][amount]" class="form-control price" value="${row.price}" oninput="calculateTotal(this)"></td>
        <td><input type="number" name="data[${i}][total_amount]" class="form-control total-amount" value="${row.total}" readonly></td>
      </tr>
    `;
        tableBody.innerHTML += newRow;
      });

      updateTotals();
      localStorage.removeItem("temp_excel_data");
    }

    restoreData();
    </script>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

</body>

</html><?php /**PATH /home/mcndhanoreco/public_html/quotation.mcndhanore.co.in/my-quote/resources/views/items.blade.php ENDPATH**/ ?>