<?php

use Illuminate\Support\Facades\Route;

use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\CustomerController;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\QuotationController;
use App\Http\Controllers\ItemController;
use App\Http\Controllers\QuotationPdfController;
use App\Http\Controllers\QuotationListController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\ReportController;

Route::get('/', [AuthController::class, 'showRegister'])->name('register');
Route::post('/', [AuthController::class, 'registerUser']);

Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'loginUser']);
Route::get('/logout', [AuthController::class, 'logout'])->name('logout');

Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');

Route::get('/customers', [CustomerController::class, 'index'])->name('customer');

Route::post('/customers/store', [CustomerController::class, 'store'])->name('customer.store');

Route::get('/home', [HomeController::class, 'index'])->name('home.index');
Route::post('/home/store', [HomeController::class, 'store'])->name('home.store');
Route::post('/home/save-customer', [HomeController::class, 'saveChosenCustomer'])->name('customer.save');

////////////////////

Route::get('/quotation', function () {
    return view('quotation');
})->name('quotation.index');

////////////////////

Route::get('/items', [ItemController::class, 'index'])->name('items');
Route::post('/items/store', [ItemController::class, 'store'])->name('items.store');
Route::get('/items/create', [ItemsController::class, 'create'])->name('items.create');



Route::post('/items', [ItemController::class, 'showItems'])->name('items');
// Route::get('/quotation', [QuotationController::class, 'index'])->name('quotation.index');
// Route::get('/quotation', [QuotationController::class, 'show'])->name('quotation');
Route::get('/quotation/view/{id}', [QuotationController::class, 'show'])->name('quotation.view');
// Route::get('/quotations/create', [QuotationController::class, 'create'])->name('quotations.create');
Route::post('/quotations/store', [QuotationController::class, 'store'])->name('quotations.store');


Route::get('/quotations', [QuotationController::class, 'index'])->name('quotations.index');

Route::get('/items/getData', [QuotationController::class, 'showData']);


Route::get('/quotation/create', [QuotationController::class, 'create'])->name('quotation.create');
Route::get('/quotations/create', [QuotationController::class, 'create'])->name('quotations.create');
Route::get('/quotation', [QuotationController::class, 'index'])->name('quotation.page');
Route::get('/select_excel_data', [QuotationController::class, 'selectExcelData'])->name('select_excel_data');


Route::get('/quotation-pdf', [QuotationController::class, 'showLatestQuotation'])->name('pdf.quotation');
Route::get('/quotation/pdf', [QuotationController::class, 'generatePdf']);
Route::get('/quotation/pdf/{id}', [QuotationController::class, 'pdfGenerate'])->name('pdf.quotationpdf');



Route::get('/quotation-list', [QuotationListController::class, 'index'])->name('quotationlist.index');
Route::get('/quotations/{id}/edit', [QuotationListController::class, 'edit'])->name('quotation.edit');
Route::put('/quotations/{id}', [QuotationListController::class, 'update'])->name('quotation.update');
Route::delete('/quotation-delete/{id}', [QuotationListController::class, 'delete'])->name('quotationlist.delete');
Route::get('/quotation-download/{id}', [QuotationListController::class, 'downloadPDF'])->name('quotationlist.pdf');
Route::put('/quotationlist/{id}', [QuotationListController::class, 'update'])->name('quotationlist.update');
Route::delete('/quotation/{id}', [QuotationListController::class, 'destroy'])->name('quotationlist.delete');
Route::get('/quotation-invoice/{id}', [InvoiceController::class, 'showInvoice'])->name('quotationlist.invoice');

Route::get('/invoice/show/{id}', [InvoiceController::class, 'showInvoice'])->name('invoice.show');
Route::get('/invoice/create/{quotation_id}', [InvoiceController::class, 'createInvoice'])->name('invoice.create');
Route::post('/invoice/store/{quotationId}', [InvoiceController::class, 'storeInvoice'])->name('invoice.store');
Route::get('/invoice/showInvoice/{id}', [InvoiceController::class, 'showlatestInvoice'])->name('pdf.invoice');


Route::get('/invoice/pdf/{id}', [InvoiceController::class, 'generatePDF'])->name('pdf.invoice');
Route::get('/invoice/{id}/edit', [InvoiceController::class, 'edit'])->name('quotationlist.invoiceedit');
Route::put('/invoice/{id}', [InvoiceController::class, 'update'])->name('invoice.update');

////report
Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');