<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Report</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <!-- Add Bootstrap for styling -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
  body {
    background-color: #f8f9fa;
    padding-top: 40px;
  }

  .container {
    max-width: 800px;
    margin: auto;
  }

  h2 {
    margin-bottom: 30px;
    text-align: center;
    color: #343a40;
  }

  .card {
    border-radius: 10px;
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.05);
  }

  ul {
    padding-left: 20px;
    margin-bottom: 0;
  }

  li {
    padding: 5px 0;
  }
  </style>
</head>

<body>

  <div class="container">
    <h2>📊 Report Summary</h2>

    <!-- Total Bills -->
    <div class="card p-3 mb-3">
      <strong>Total Bills:</strong> {{ $totalBills }}
    </div>

    <!-- Month-wise -->
    <div class="card p-3 mb-3">
      <h4>📅 Month-wise Bills</h4>
      <ul>
        @foreach($monthWise as $month => $bills)
        <li>{{ $month }}: {{ $bills->count() }}</li>
        @endforeach
      </ul>
    </div>

    <!-- Client-wise -->
    <div class="card p-3 mb-3">
      <h4>👤 Client-wise Bills</h4>
      <ul>
        @foreach($clientWise as $clientId => $bills)
        <li>{{ $bills->first()->customer->customer_name ?? 'Unknown' }}: {{ $bills->count() }}</li>
        @endforeach
      </ul>
    </div>

    <!-- Date-wise -->
    <div class="card p-3 mb-3">
      <h4>📆 Date-wise Bills</h4>
      <ul>
        @foreach($dateWise as $date => $bills)
        <li>{{ $date }}: {{ $bills->count() }}</li>
        @endforeach
      </ul>
    </div>
  </div>

</body>

</html>