<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Invoice</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <style>
  .container {
    margin-top: 20px;
  }

  .summary p {
    font-weight: bold;
  }
  </style>
</head>

<body>
  <div class="container">
    <h2>Edit Invoice</h2>
    <form action=" {{ route('invoice.update', $invoice->id) }}" method="POST">
      @csrf
      @method('PUT')

      <input type="hidden" id="customer_state" name="customer_state" value="{{ $invoice->customer_state }}">
      <div class="mb-3">
        <label>Invoice Number:</label>
        <input type="text" name="invoice_number" value="{{ $invoice->invoice_number }}" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Customer Name:</label>
        <input type="text" name="customer_name" value="{{ $invoice->customer_name }}" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Quotation Date:</label>
        <input type="date" name="invoice_date" value="{{ $invoice->invoice_date }}" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>GST Rate (%):</label>
        <input type="number" id="gst_rate" name="gst_rate" value="{{ $invoice->gst_rate }}" class="form-control"
          required>
      </div>
      <div class="mb-3">
        <label>GST Type:</label>
        <input id="gst_type" name="gst_type" value="{{ $invoice->gst_type }}" class="form-control" required readonly>
      </div>

      <table class="table" id="itemsTable">
        <thead>
          <tr>
            <th>Sr No</th>
            <th>Item Description</th>
            <th>Qty</th>
            <th>Price</th>
            <th>Total Amount</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($quotationitems as $index => $item)
          <tr>
            <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
            <td>
              <input type="number" name="items[{{ $index }}][sr_no]" value="{{ $item->sr_no ?? $index + 1 }}"
                class="form-control" required>
            </td>

            <td><input type="text" name="items[{{ $index }}][description]" class="form-control"
                value="{{ $item->description }}" required></td>
            <td><input type="number" name="items[{{ $index }}][quantity]" class="form-control quantity"
                value="{{ $item->quantity }}" required></td>
            <td><input type="number" name="items[{{ $index }}][price]" class="form-control price"
                value="{{ $item->amount }}" required></td>
            <td><input type="text" name="items[{{ $index }}][total]" class="form-control total"
                value="{{ $item->total_amount }}" readonly></td>
            <td><button type="button" class="btn btn-danger remove-item">X</button></td>
          </tr>
          @endforeach
        </tbody>
      </table>

      <button type="button" id="addItem" class="btn btn-primary">Add Item</button>

      <div class="summary mt-3">
        <p><strong>Sub Total:</strong> ₹<span id="subtotal">0.00</span></p>
        <p><strong>CGST:</strong> ₹<span id="cgst">0.00</span></p>
        <p><strong>SGST:</strong> ₹<span id="sgst">0.00</span></p>
        <p><strong>IGST:</strong> ₹<span id="igst">0</span></p>
        <p><strong>Grand Total:</strong> ₹<span id="grand_total">0.00</span></p>

        <input type="hidden" name="subtotal_value" id="subtotal_value">
        <input type="hidden" name="cgst_value" id="cgst_value">
        <input type="hidden" name="sgst_value" id="sgst_value">
        <input type="hidden" name="igst_value" id="igst_value">
        <input type="hidden" name="grand_total_value" id="grand_total_value">
      </div>

      <div class="row ">
        <div class="col-md-4">
          <div class="total-section" style=" width: 250px; margin-top: 10px; ">
            <h6>Subtotal: ₹ {{ number_format($invoice->subtotal, 2) }}</h6>

            <input type="hidden" id="hiddenGrandTotal" value="{{ $invoice->grand_total }}">
            <input type="hidden" id="hiddenBalanceDue" name="balance_due" value="{{ $invoice->grand_total }}">

            <label for="discount"><strong>Discount (%):</strong></label>
            <input type="number" id="discount" name="discount" class="form-control" oninput="updateBalanceDue()"
              value="{{$invoice->discount}}" max="100" step="0.01" />

            <h5 class="mt-3">Balance Due:
              <span id="balanceDue">₹ {{ number_format($invoice->grand_total, 2) }}</span>
            </h5>
          </div>
        </div>
      </div>

      <button type="submit" class="btn btn-success">Update Quotation</button>
    </form>
  </div>

  <script>
  document.addEventListener("DOMContentLoaded", function() {
    function calculateTotals() {
      let subtotal = 0;
      document.querySelectorAll(".total").forEach(input => {
        subtotal += parseFloat(input.value) || 0;
      });

      const gstRate = parseFloat(document.getElementById("gst_rate").value) || 0;
      const gstType = document.getElementById("gst_type").value;
      const customerState = document.getElementById("customer_state").value.toLowerCase();
      const companyState = "maharashtra"; // Set your actual company state here

      let cgst = 0,
        sgst = 0,
        igst = 0,
        grandTotal = 0;

      if (gstType === "excluding") {
        gstTotal = (subtotal * gstRate) / 100;
        grandTotal = subtotal + gstTotal;
      } else {
        gstTotal = subtotal - (subtotal / (1 + gstRate / 100));
        grandTotal = subtotal;
        subtotal = subtotal - gstTotal;
      }

      const isIntraState = (customerState === companyState.toLowerCase());

      if (isIntraState) {
        cgst = sgst = gstTotal / 2;
        igst = 0;
        grandTotal = subtotal + cgst + sgst;
      } else {
        cgst = sgst = 0;
        igst = gstTotal;
        grandTotal = subtotal + igst;
      }

      document.getElementById("subtotal").innerText = subtotal.toFixed(2);
      document.getElementById("cgst").innerText = cgst.toFixed(2);
      document.getElementById("sgst").innerText = sgst.toFixed(2);
      document.getElementById("igst").innerText = igst.toFixed(2);
      document.getElementById("grand_total").innerText = grandTotal.toFixed(2);


      // Set hidden values for form submission
      document.getElementById("subtotal_value").value = subtotal.toFixed(2);
      document.getElementById("cgst_value").value = cgst.toFixed(2);
      document.getElementById("sgst_value").value = sgst.toFixed(2);
      document.getElementById("igst_value").value = igst.toFixed(2);
      document.getElementById("grand_total_value").value = grandTotal.toFixed(2);
    }

    document.querySelector("#itemsTable").addEventListener("input", function(event) {
      if (event.target.classList.contains("quantity") || event.target.classList.contains("price")) {
        let row = event.target.closest("tr");
        let quantity = parseFloat(row.querySelector(".quantity").value) || 0;
        let price = parseFloat(row.querySelector(".price").value) || 0;
        let total = quantity * price;
        row.querySelector(".total").value = total.toFixed(2);
        calculateTotals();
      }
    });

    document.getElementById("addItem").addEventListener("click", function() {
      let rowCount = document.querySelectorAll("#itemsTable tbody tr").length;
      let newRow = `
        <tr>
           <td><input type="number" name="items[${rowCount}][sr_no]"  class="form-control" required></td>
          <td><input type="text" name="items[${rowCount}][description]" class="form-control" required></td>
          <td><input type="number" name="items[${rowCount}][quantity]" class="form-control quantity" required></td>
          <td><input type="number" name="items[${rowCount}][price]" class="form-control price" required></td>
          <td><input type="text" name="items[${rowCount}][total]" class="form-control total" readonly></td>
          <td><button type="button" class="btn btn-danger remove-item">X</button></td>
        </tr>`;
      document.querySelector("#itemsTable tbody").insertAdjacentHTML("beforeend", newRow);
      calculateTotals();
    });

    function updateBalanceDue() {
      let grandTotal = parseFloat(document.getElementById("hiddenGrandTotal").value) || 0;
      let discountPercent = parseFloat(document.getElementById("discount").value) || 0;
      let discountAmount = (grandTotal * discountPercent) / 100;

      let balanceDue = grandTotal - discountAmount;

      document.getElementById("balanceDue").innerText = "₹ " + balanceDue.toFixed(2);
      document.getElementById("hiddenBalanceDue").value = balanceDue.toFixed(2);

    }

    document.getElementById("discount").addEventListener("input", updateBalanceDue);


    document.querySelector("#itemsTable").addEventListener("click", function(event) {
      if (event.target.classList.contains("remove-item")) {
        event.target.closest("tr").remove();
        calculateTotals();
      }
    });

    document.querySelector("#itemsTable").addEventListener("click", function(event) {
      if (event.target.classList.contains("remove-item")) {
        event.target.closest("tr").remove();
        calculateTotals();
      }
    });

    document.getElementById("gst_rate").addEventListener("input", calculateTotals);
    document.getElementById("gst_type").addEventListener("change", calculateTotals);

    calculateTotals(); // Initial call
  });
  </script>

</body>

</html>