<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Quotation;
use App\Models\Invoice;
use App\Models\QuotationItem;
use App\Models\InvoiceItem;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Validation\Rule;


class InvoiceController extends Controller
{
    public function index() {
       
        return view('quotationlist.invoice');
    }

    
    public function showInvoice( $id)
{
    $quotation = Quotation::with('items')->findOrFail($id);
    $quotationitems = QuotationItem::where('quotation_id', $id)->get();

    // Generate Invoice Number
    $latestInvoice = Invoice::latest()->first();
    // Generate the new invoice number
 $latestInvoice = Invoice::where('invoice_number', 'like', 'AIN-' . now()->format('ym') . '-%')
 ->orderBy('id', 'desc')
 ->first();

if ($latestInvoice) {
 $lastNumber = (int) substr($latestInvoice->invoice_number, -5);
 $newNumber = str_pad($lastNumber + 1, 5, '0', STR_PAD_LEFT);
} else {
 $newNumber = '00001'; // Start from 00001 if no previous quotations exist
}

$invoiceNumber = 'AIN-' . now()->format('ym') . '-' . $newNumber;

    $invoiceDate =  now()->format('Y-m-d');

  

    return view('quotationlist.invoice', compact('quotation', 'quotationitems', 'invoiceNumber','invoiceDate'));
}


public function createInvoice($quotationId) {
    $quotation = Quotation::findOrFail($quotationId);
    $quotationitems = QuotationItem::where('quotation_id', $quotationId)->get();
    $latestInvoice = Invoice::latest()->first();
  

    ////////////////////////////////////////////////

 // Generate the new invoice number
 $latestInvoice = Invoice::where('invoice_number', 'like', 'AIN-' . now()->format('ym') . '-%')
 ->orderBy('id', 'desc')
 ->first();

if ($latestInvoice) {
 $lastNumber = (int) substr($latestInvoice->invoice_number, -5);
 $newNumber = str_pad($lastNumber + 1, 5, '0', STR_PAD_LEFT);
} else {
 $newNumber = '00001'; // Start from 00001 if no previous quotations exist
}

$invoiceNumber = 'AIN-' . now()->format('ym') . '-' . $newNumber;

    ///////////////////////////////////////////////////



    return view('quotationlist.invoice', compact('quotation', 'quotationitems', 'invoiceNumber'));
}

public function storeInvoice(Request $request, $quotationId)
{
   

    $validated = $request->validate([
        
            'discount' => 'required|numeric',
            'balance_due' => 'required|numeric',
           
    ]);
    
    $quotation = Quotation::findOrFail($quotationId);
    $quotationitems = QuotationItem::where('quotation_id', $quotationId)->get();
    
    $latestInvoice = Invoice::latest()->first();
   // Generate the new invoice number
 $latestInvoice = Invoice::where('invoice_number', 'like', 'AIN-' . now()->format('ym') . '-%')
 ->orderBy('id', 'desc')
 ->first();

if ($latestInvoice) {
 $lastNumber = (int) substr($latestInvoice->invoice_number, -5);
 $newNumber = str_pad($lastNumber + 1, 5, '0', STR_PAD_LEFT);
} else {
 $newNumber = '00001'; // Start from 00001 if no previous quotations exist
}

$invoiceNumber = 'AIN-' . now()->format('ym') . '-' . $newNumber;
    
 // Create new invoice
 $invoice = Invoice::create([
    'invoice_number' => $invoiceNumber,
    'invoice_date' => now()->format('Y-m-d'),
    'company_name' => $quotation->company_name,
    'customer_name' => $quotation->customer_name,
    'address' => $quotation->address,
    'contact' => $quotation->contact,
    'email' => $quotation->email,
    'state' => $quotation->state,
    'gst_number' => $quotation->gst_number,
    'subtotal' => $quotation->subtotal,
    'discount' => $validated['discount'],
    'balance_due' => $validated['balance_due'],
    'hsn_number' => $quotation->hsn_number,
    'cgst' => $quotation->cgst,
    'sgst' => $quotation->sgst,
    'igst' => $quotation->igst,
    'grand_total' => $quotation->grand_total,
    'gst_rate' => $quotation->gst_rate,
    'gst_type' => $quotation->gst_type,
]);

 // Store Invoice Items
 foreach ($quotationitems as $item) {
    InvoiceItem::create([
        'invoice_id' => $invoice->id,
        'sr_no' => $item->sr_no,
        'description' => $item->description,
        'quantity' => $item->quantity,
        'amount' => $item->amount,
        'total_amount' => $item->total_amount,
    ]);
}
    

    return redirect()->route('pdf.invoice', ['id' => $invoice->id])
    ->with('success', 'Invoice generated successfully.');
}


public function showlatestInvoice($id)
{
    $invoice = Invoice::findOrFail($id);
    
    // $quotation = Quotation::with('items')->where('id', $invoice->quotation_id)->first();
    $items = QuotationItem::where('invoice_id', $invoice->id)->get();


    return redirect()->route('pdf.invoice', compact('quotation', 'quotationItems', 'invoice'));
    
}

public function generatePDF($id)
    {
        // Fetch invoice data from database
        $invoice = Invoice::findOrFail($id);
        $items = InvoiceItem::where('invoice_id', $id)->get();
        $invoice->balance_due_in_words = $this->convertToIndianWords($invoice->balance_due);
        

        // Load PDF view and pass data
        $pdf = PDF::loadView('pdf.invoice', compact('invoice', 'items'));

        // Return generated PDF
        return $pdf->download('invoice_'.$invoice->invoice_no.'.pdf');
    }

    public static function convertToIndianWords($number)
    {
        $words = [
            '0' => '', '1' => 'One', '2' => 'Two', '3' => 'Three',
            '4' => 'Four', '5' => 'Five', '6' => 'Six', '7' => 'Seven',
            '8' => 'Eight', '9' => 'Nine', '10' => 'Ten',
            '11' => 'Eleven', '12' => 'Twelve', '13' => 'Thirteen',
            '14' => 'Fourteen', '15' => 'Fifteen', '16' => 'Sixteen',
            '17' => 'Seventeen', '18' => 'Eighteen', '19' => 'Nineteen',
            '20' => 'Twenty', '30' => 'Thirty', '40' => 'Fourty',
            '50' => 'Fifty', '60' => 'Sixty', '70' => 'Seventy',
            '80' => 'Eighty', '90' => 'Ninety'
        ];

        $digits = ['', 'Hundred', 'Thousand', 'Lakh', 'Crore'];
        $number = round($number);
        $str = [];

        $i = 0;
        while ($number > 0) {
            if ($i == 1) {
                $divider = 10;
            } else {
                $divider = 100;
            }

            $numberPart = $number % $divider;
            $number = floor($number / $divider);

            if ($numberPart) {
                $plural = (($counter = count($str)) && $numberPart > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                if ($numberPart < 21) {
                    $word = $words[$numberPart];
                } else {
                    $word = $words[floor($numberPart / 10) * 10] . " " . $words[$numberPart % 10];
                }

                $str[] = $word . " " . $digits[$i];
            }
            $i++;
        }

        return implode(' ', array_reverse($str));
    }


public function edit($id)
{
     $quotation = Quotation::findOrFail($id);
    $quotationitems = QuotationItem::where('quotation_id', $id)->get();
    $invoice = Invoice::with('items')->findOrFail($id);
    $invoiceitems = InvoiceItem::where('invoice_id', $id)->get();
    $companyState = 'Maharashtra';
    
    return view('quotationlist.invoiceedit', compact('invoice','invoiceitems','companyState','quotationitems', 'quotation'));
}

public function update(Request $request, $id)
{
  
    // $invoice = Invoice::findOrFail($id);

     // Find the quotation and include quotation items
     $invoice = Invoice::with('items')->findOrFail($id);
      $quotation = Quotation::findOrFail($id);
    $quotationitems = QuotationItem::where('quotation_id', $id)->get();
     
  // Get frontend-calculated values
  $subtotal    = (float) $request->input('subtotal_value');
  $cgst        = (float) $request->input('cgst_value');
  $sgst        = (float) $request->input('sgst_value');
  $igst        = (float) $request->input('igst_value');
  $grandTotal  = (float) $request->input('grand_total_value');
  $discount = $request->input('discount');
  $grand_total = $request->input('balance_due');
     // Ensure quotation items exist before calling pluck()
     $existingItemIds = $invoice->items ? $invoice->items->pluck('id')->toArray() : [];

     // Get the updated item IDs from the request
     $updatedItemIds = collect($request->items)->pluck('id')->filter()->toArray();
 
     // Find items that are removed (present in database but not in request)
     $itemsToDelete = array_diff($existingItemIds, $updatedItemIds);
 
     // Delete removed items from the database
     InvoiceItem::whereIn('id', $itemsToDelete)->delete();

    
    
    foreach ($request->items as $index => $item) {
        if (isset($item['id']) && !empty($item['id'])) {
            InvoiceItem::where('id', $item['id'])->update([
                'sr_no' =>$index + 1,
                'description' => $item['description'],
                'quantity' => $item['quantity'],
                'amount' => $item['price'],
                'total_amount' => $item['total']
            ]);
        } else {
            InvoiceItem::create([
                'invoice_id' => $invoice->id,
                'sr_no' => $index + 1,
                'description' => $item['description'],
                'quantity' => $item['quantity'],
                'amount' => $item['price'],
                'total_amount' => $item['total']
            ]);
        }
    }

       // Update quotation
       $invoice->update([
        'invoice_number' => $request->invoice_number,
        'invoice_date' => $request->invoice_date,
        'customer_name' => $request->customer_name,
        'gst_rate' => $request->gst_rate,
        'subtotal' => $subtotal,
        'cgst' => $cgst,
        'sgst' => $sgst,
        'igst' => $igst,
        'grand_total' => $grandTotal,
        'discount' => $discount,
        'balance_due' => $grand_total,
    ]);

    

    return redirect()->route('quotationlist.index')->with('success', 'Quotation updated successfully');
}




}