<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Customer;
use Illuminate\Support\Facades\Validator;

class CustomerController extends Controller
{
    public function index()
    {
        $customers = Customer::paginate(5);
       

        return view('customer', compact('customers'));
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'company_name' => 'nullable|string|max:255',
            'customer_name' => ['required', 'regex:/^[A-Z][a-zA-Z\s]*$/','unique:customers,customer_name'],
            'contact' => 'required|string|max:10',
            'gst_number' => 'nullable|string',
            'email' => 'required|string|unique:customers,email',
            'address' => 'required|string',
            'city' => 'required|string',
            'state' => 'required|string',
        // ], [
        //     'customer_name.unique' => 'Customer already exists.',
        ]);

        

        $validator->after(function ($validator) use ($request) {
            $companyName = $request->company_name;
            $customerName = $request->customer_name;
            $address = $request->address;
            $city = $request->city;
        
            // Compare fields and add error if any are the same
            if ($companyName && $companyName === $customerName) {
                $validator->errors()->add('company_name', 'Company Name and Customer Name should not be the same.');
            }
            if ($customerName === $address) {
                $validator->errors()->add('customer_name', 'Customer Name and Address should not be the same.');
            }
            if ($address === $city) {
                $validator->errors()->add('address', 'Address and City should not be the same.');
            }
            if ($customerName === $city) {
                $validator->errors()->add('customer_name', 'Customer Name and City should not be the same.');
            }
        });
        
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

         // Store customer data in the database
         Customer::create([
            'company_name' => $request->company_name,
            'customer_name' => $request->customer_name,
            'contact' => $request->contact,
            'gst_number' => $request->gst_number,
            'email' => $request->email,
            'address' => $request->address,
            'city' => $request->city,
            'state' => $request->state,
        ]);

          // Redirect with a success message
          return redirect()->route('customer')->with('success', 'Customer added successfully!');
    }
}