<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Edit Quotation</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <style>
  .container {
    margin-top: 20px;
  }

  .summary p {
    font-weight: bold;
  }
  </style>
</head>

<body>
  <div class="container">
    <h2>Edit Quotation</h2>
    <form action="{{ route('quotationlist.update', $quotation->id) }}" method="POST">
      @csrf
      @method('PUT')

      <div class="mb-3">
        <label>Quotation Number:</label>
        <input type="text" name="quotation_number" value="{{ $quotation->quotation_number }}" class="form-control"
          required>
      </div>

      <div class="mb-3">
        <label>Customer Name:</label>
        <input type="text" name="customer_name" value="{{ $quotation->customer_name }}" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>Quotation Date:</label>
        <input type="date" name="quotation_date" value="{{ $quotation->quotation_date }}" class="form-control" required>
      </div>

      <div class="mb-3">
        <label>GST Rate (%):</label>
        <input type="number" id="gst_rate" name="gst_rate" value="{{ $quotation->gst_rate }}" class="form-control"
          required>
      </div>

      <table class="table" id="itemsTable">
        <thead>
          <tr>
            <th>Item Description</th>
            <th>Qty</th>
            <th>Price</th>
            <th>Total Amount</th>
            <th>Action</th>
          </tr>
        </thead>
        <tbody>
          @foreach ($quotationitems as $index => $item)
          <tr>
            <input type="hidden" name="items[{{ $index }}][id]" value="{{ $item->id }}">
            <td><input type="text" name="items[{{ $index }}][description]" class="form-control"
                value="{{ $item->description }}" required></td>
            <td><input type="number" name="items[{{ $index }}][quantity]" class="form-control quantity"
                value="{{ $item->quantity }}" required></td>
            <td><input type="number" name="items[{{ $index }}][price]" class="form-control price"
                value="{{ $item->amount }}" required></td>
            <td><input type="text" name="items[{{ $index }}][total]" class="form-control total"
                value="{{ $item->total_amount }}" readonly></td>
            <td><button type="button" class="btn btn-danger remove-item">X</button></td>
          </tr>
          @endforeach
        </tbody>
      </table>

      <button type="button" id="addItem" class="btn btn-primary">Add Item</button>

      <div class="summary mt-3">
        <p><strong>Sub Total:</strong> ₹<span id="subtotal">0.00</span></p>
        <p><strong>CGST:</strong> ₹<span id="cgst">0.00</span></p>
        <p><strong>SGST:</strong> ₹<span id="sgst">0.00</span></p>
        <p><strong>Grand Total:</strong> ₹<span id="grand_total">0.00</span></p>
      </div>

      <button type="submit" class="btn btn-success">Update Quotation</button>
    </form>
  </div>

  <script>
  document.addEventListener("DOMContentLoaded", function() {
    function calculateTotals() {
      let subtotal = 0;
      document.querySelectorAll(".total").forEach(input => {
        subtotal += parseFloat(input.value) || 0;
      });
      document.getElementById("subtotal").innerText = subtotal.toFixed(2);

      let gstRate = parseFloat(document.getElementById("gst_rate").value) || 0;
      let cgst = (subtotal * (gstRate / 2) / 100).toFixed(2);
      let sgst = (subtotal * (gstRate / 2) / 100).toFixed(2);
      let grandTotal = (subtotal + parseFloat(cgst) + parseFloat(sgst)).toFixed(2);

      document.getElementById("cgst").innerText = cgst;
      document.getElementById("sgst").innerText = sgst;
      document.getElementById("grand_total").innerText = grandTotal;
    }

    document.querySelector("#itemsTable").addEventListener("input", function(event) {
      if (event.target.classList.contains("quantity") || event.target.classList.contains("price")) {
        let row = event.target.closest("tr");
        let quantity = row.querySelector(".quantity").value;
        let price = row.querySelector(".price").value;
        let total = (quantity * price).toFixed(2);
        row.querySelector(".total").value = total;
        calculateTotals();
      }
    });

    document.getElementById("addItem").addEventListener("click", function() {
      let rowCount = document.querySelectorAll("#itemsTable tbody tr").length;
      let newRow = `
        <tr>
          <td><input type="text" name="items[${rowCount}][description]" class="form-control" required></td>
          <td><input type="number" name="items[${rowCount}][quantity]" class="form-control quantity" required></td>
          <td><input type="number" name="items[${rowCount}][price]" class="form-control price" required></td>
          <td><input type="text" name="items[${rowCount}][total]" class="form-control total" readonly></td>
          <td><button type="button" class="btn btn-danger remove-item">X</button></td>
        </tr>`;
      document.querySelector("#itemsTable tbody").insertAdjacentHTML("beforeend", newRow);
    });

    document.querySelector("#itemsTable").addEventListener("click", function(event) {
      if (event.target.classList.contains("remove-item")) {
        event.target.closest("tr").remove();
        calculateTotals();
      }
    });

    document.getElementById("gst_rate").addEventListener("input", calculateTotals);

    calculateTotals();
  });
  </script>
</body>

</html>