<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AuthMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {

        if (!session()->has('user')) {
            return redirect('/login')->with('error', 'Please login first.');
        }
        return $next($request);
    }

    protected $routeMiddleware = [
        'auth' => \App\Http\Middleware\AuthMiddleware::class,
    ];
    
}