<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\Quotation; // Import the Quotation model
use App\Models\QuotationItem;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\DB;
use NumberToWords\NumberToWords;
class QuotationListController extends Controller
{
    
    public function index()
    {
        // Fetch all quotations from the database
        $quotations = Quotation::all();
       $quotationitems = QuotationItem::all();
       
        return view('quotation_list', compact('quotations','quotationitems'));
    }

    public function edit($id)
    { //dd($id);
        $quotation = Quotation::with('items')->findOrFail($id);
        $quotationitems = QuotationItem::where('quotation_id', $id)->get();
          // Fetch quotation items
    
       
        return view('quotationlist.edit', compact('quotation','quotationitems'));
    }
    
    public function update(Request $request, $id)
{
    $quotation = Quotation::findOrFail($id);

     // Find the quotation and include quotation items
     $quotation = Quotation::with('items')->findOrFail($id);
     

    $quotation->update($request->only([
        'quotation_number', 'quotation_date', 'customer_name', 'gst_rate', 'subtotal', 'cgst', 'sgst', 'grand_total'
    ]));

     // Ensure quotation items exist before calling pluck()
     $existingItemIds = $quotation->items ? $quotation->items->pluck('id')->toArray() : [];

     // Get the updated item IDs from the request
     $updatedItemIds = collect($request->items)->pluck('id')->filter()->toArray();
 
     // Find items that are removed (present in database but not in request)
     $itemsToDelete = array_diff($existingItemIds, $updatedItemIds);
 
     // Delete removed items from the database
     QuotationItem::whereIn('id', $itemsToDelete)->delete();

      // Calculate subtotal (sum of total_amount from all items)
    $subtotal = collect($request->items)->sum(function ($item) {
        return $item['quantity'] * $item['price'];
    });
    
      // Define GST rate (9% each for CGST & SGST)
      $gst_rate = $quotation->gst_rate / 100;
      $cgst = $subtotal * ($gst_rate/2);
      $sgst = $subtotal * ($gst_rate/2);

      // Calculate grand total
      $grand_total = $subtotal + $cgst + $sgst;
       // Update Quotation Details
       $quotation->update([
        'quotation_number' => $request->quotation_number,
        'quotation_date' => $request->quotation_date,
        'customer_name' => $request->customer_name,
        'gst_rate' => $request->gst_rate,
        'subtotal' => $subtotal,
        'cgst' => $cgst,
        'sgst' => $sgst,
        'grand_total' => $grand_total,
    ]);
      
    foreach ($request->items as $item) {
        if (isset($item['id']) && !empty($item['id'])) {
            QuotationItem::where('id', $item['id'])->update([
                'description' => $item['description'],
                'quantity' => $item['quantity'],
                'amount' => $item['price'],
                'total_amount' => $item['total']
            ]);
        } else {
            QuotationItem::create([
                'quotation_id' => $quotation->id,
                'description' => $item['description'],
                'quantity' => $item['quantity'],
                'amount' => $item['price'],
                'total_amount' => $item['total']
            ]);
        }
    }

       // Update quotation
       $quotation->update([
        'quotation_number' => $request->quotation_number,
        'quotation_date' => $request->quotation_date,
        'customer_name' => $request->customer_name,
        'gst_rate' => $request->gst_rate,
        'subtotal' => $subtotal,
        'cgst' => $cgst,
        'sgst' => $sgst,
        'grand_total' => $grand_total,
    ]);

    return redirect()->route('quotationlist.index')->with('success', 'Quotation updated successfully');
}
public function delete($id)
{
    $quotation = Quotation::findOrFail($id);
    $quotation->delete();

    return redirect()->route('quotationlist.index')->with('success', 'Quotation deleted successfully');
}

public function destroy($id)
{
    $quotation = Quotation::findOrFail($id);

    // Delete associated quotation items first
    QuotationItem::where('quotation_id', $quotation->id)->delete();

    // Then delete the quotation
    $quotation->delete();

    return redirect()->route('quotationlist.index')->with('success', 'Quotation deleted successfully.');
}


public function downloadPdf($id)
{
    // Fetch quotation details along with items
    $quotation = Quotation::with('items')->findOrFail($id);
    $quotationitems = QuotationItem::where('quotation_id', $id)->get();
    $quotation->grand_total_in_words = $this->numberToWords($quotation->grand_total);
    // Load the PDF view and pass data
    $pdf = PDF::loadView('quotationlist.pdf', compact('quotation','quotationitems'));
   
    // Return the generated PDF
    return $pdf->download('Quotation-' . $quotation->quotation_number . '.pdf');
}

function numberToWords($number) {
    $words = new NumberToWords();
    $numberTransformer = $words->getNumberTransformer('en');
    return ucwords($numberTransformer->toWords($number)) . ' Only';
}

}