<!DOCTYPE html>
<html>

<head>
  <title>Edit Invoice</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  {{-- Bootstrap CSS (optional, for styling) --}}
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>

  <div class="container mt-5">
    <h2>Edit Invoice</h2>

    <form action="{{ route('invoice.update', $invoice->id) }}" method="POST">
      @csrf
      @method('PUT')
      <div class="mb-3">
        <label>Invoice Number</label>
        <input type="text" name="invoice_number" class="form-control" value="{{ $invoice->invoice_number }}" required>
      </div>

      <div class="mb-3">
        <label>Date</label>
        <input type="date" name="invoice_date" class="form-control" value="{{ $invoice->invoice_date }}" required>
      </div>
      <div class="mb-3">
        <label>Customer Name:</label>
        <input type="text" name="customer_name" value="{{ $invoice->customer_name }}" class="form-control" required>
      </div>
      <div class="mb-3">
        <label>GST Rate (%):</label>
        <input type="number" id="gst_rate" name="gst_rate" value="{{ $invoice->gst_rate }}" class="form-control"
          required>
      </div>
      <div class="mb-3">
        <label>GST Type:</label>
        <input id="gst_type" name="gst_type" value="{{ $invoice->gst_type }}" class="form-control" required readonly>
      </div>

      <h5>Items</h5>

      <div id="items">
        <table class="table" id="itemsTable">
          <thead>
            <tr>
              <th>Sr No</th>
              <th>Item Description</th>
              <th>Qty</th>
              <th>Price</th>
              <th>Total Amount</th>
              <th>Action</th>
            </tr>
          </thead>
          <tbody>
            @foreach ($invoice->items as $index => $item)
            <tr>
              <td><input type="text" name="items[{{ $index }}][sr_no]" value="{{ $item->sr_no }}" class="form-control"
                  required></td>
              <td><input type="text" name="items[{{ $index }}][description]" value="{{ $item->description }}"
                  class="form-control" required></td>
              <td><input type="number" name="items[{{ $index }}][quantity]" value="{{ $item->quantity }}"
                  class="form-control quantity" required></td>
              <td><input type="number" name="items[{{ $index }}][amount]" value="{{ $item->amount }}"
                  class="form-control price" required></td>
              <td><input type="text" name="items[{{ $index }}][total_amount]" value="{{ $item->total_amount }}"
                  class="form-control total" readonly></td>
              <td><button type="button" class="btn btn-danger remove-item">X</button></td>
            </tr>
            @endforeach
          </tbody>
        </table>

        <div class="summary mt-3">
          <p><strong>Sub Total:</strong> ₹<span id="subtotal">0.00</span></p>
          <p><strong>CGST:</strong> ₹<span id="cgst">0.00</span></p>
          <p><strong>SGST:</strong> ₹<span id="sgst">0.00</span></p>
          <p><strong>Grand Total:</strong> ₹<span id="grand_total">0.00</span></p>
        </div>

      </div>

      <div class="row ">
        <div class="col-md-4">
          <div class="total-section" style=" width: 200px; margin-top: 10px;">
            <h4>Subtotal: ₹ {{ number_format($invoice->subtotal, 2) }}</h4>

            <input type="hidden" id="hiddenGrandTotal" value="{{ $invoice->grand_total }}">
            <input type="hidden" id="hiddenBalanceDue" name="balance_due" value="{{ $invoice->grand_total }}">

            <label for="discount"><strong>Discount (%):</strong></label>
            <input type="number" id="discount" name="discount" class="form-control" oninput="updateBalanceDue()"
              value="{{$invoice->discount}}" max="100" step="0.01" />

            <h4 class="mt-3">Balance Due:
              <span id="balanceDue">₹ {{ number_format($invoice->grand_total, 2) }}</span>
            </h4>
          </div>
        </div>
      </div>

      <div>
        <button type="button" id="addItem" class="btn btn-primary">Add Item</button>
        <button type="submit" class="btn btn-success">Update Invoice</button>
        <a href="{{ route('quotationlist.index') }}" class="btn btn-secondary">Cancel</a>
      </div>
    </form>
  </div>

  {{-- Optional: Bootstrap JS (if needed) --}}
  <script src=" https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

  <script>
  document.addEventListener("DOMContentLoaded", function() {
    function calculateTotals() {
      let subtotal = 0;
      document.querySelectorAll(".total").forEach(input => {
        subtotal += parseFloat(input.value) || 0;
      });

      const gstRate = parseFloat(document.getElementById("gst_rate").value) || 0;
      const gstType = document.getElementById("gst_type").value;

      let cgst = 0,
        sgst = 0,
        grandTotal = 0;

      if (gstType === 'excluding') {
        // GST will be added on top
        cgst = subtotal * (gstRate / 2) / 100;
        sgst = subtotal * (gstRate / 2) / 100;
        grandTotal = subtotal + cgst + sgst;
      } else {
        // GST is already included in total
        let gstMultiplier = (100 + gstRate) / 100;
        let baseAmount = subtotal / gstMultiplier;
        cgst = baseAmount * (gstRate / 2) / 100;
        sgst = baseAmount * (gstRate / 2) / 100;
        subtotal = baseAmount;
        grandTotal = subtotal + cgst + sgst;
      }



      document.getElementById("subtotal").innerText = subtotal.toFixed(2);
      document.getElementById("cgst").innerText = cgst.toFixed(2);
      document.getElementById("sgst").innerText = sgst.toFixed(2);
      document.getElementById("grand_total").innerText = grandTotal.toFixed(2);
    }

    document.querySelector("#itemsTable").addEventListener("input", function(event) {
      if (event.target.classList.contains("quantity") || event.target.classList.contains("price")) {
        let row = event.target.closest("tr");
        let quantity = parseFloat(row.querySelector(".quantity").value) || 0;
        let price = parseFloat(row.querySelector(".price").value) || 0;
        let total = quantity * price;
        row.querySelector(".total").value = total.toFixed(2);
        calculateTotals();
      }
    });

    document.getElementById("addItem").addEventListener("click", function() {
      let rowCount = document.querySelectorAll("#itemsTable tbody tr").length;
      let newRow = `
        <tr>
           <td><input type="number" name="items[${rowCount}][sr_no]"  class="form-control" required></td>
          <td><input type="text" name="items[${rowCount}][description]" class="form-control" required></td>
          <td><input type="number" name="items[${rowCount}][quantity]" class="form-control quantity" required></td>
          <td><input type="number" name="items[${rowCount}][price]" class="form-control price" required></td>
          <td><input type="text" name="items[${rowCount}][total]" class="form-control total" readonly></td>
          <td><button type="button" class="btn btn-danger remove-item">X</button></td>
        </tr>`;
      document.querySelector("#itemsTable tbody").insertAdjacentHTML("beforeend", newRow);
    });

    function updateBalanceDue() {
      let grandTotal = parseFloat(document.getElementById("hiddenGrandTotal").value) || 0;
      let discountPercent = parseFloat(document.getElementById("discount").value) || 0;
      let discountAmount = (grandTotal * discountPercent) / 100;

      let balanceDue = grandTotal - discountAmount;

      document.getElementById("balanceDue").innerText = "₹ " + balanceDue.toFixed(2);
      document.getElementById("hiddenBalanceDue").value = balanceDue.toFixed(2);
    }

    document.getElementById("discount").addEventListener("input", updateBalanceDue);


    document.querySelector("#itemsTable").addEventListener("click", function(event) {
      if (event.target.classList.contains("remove-item")) {
        event.target.closest("tr").remove();
        calculateTotals();
      }
    });

    document.getElementById("gst_rate").addEventListener("input", calculateTotals);
    document.getElementById("gst_type").addEventListener("change", calculateTotals);

    calculateTotals(); // Initial call
  });
  </script>
</body>

</html>