<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Existing Customer</title>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
  <!-- Add this to your <head> -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

</head>

<style>
body {
  background-color: #f8f9fa;
  display: flex;
  height: 90%;
  overflow: hidden;
}

.sidebar {
  width: 250px;
  background: linear-gradient(135deg, #2c3e50, #2a5298);
  padding: 20px;
  color: white;
  height: 100%;
  position: fixed;
  left: 0;
  top: 0;
}

.sidebar img {
  width: 100px;
  height: auto;
  margin-bottom: 20px;
}

.sidebar a {
  display: block;
  color: white;
  text-decoration: none;
  padding: 10px;
  margin: 10px 0;
  border-radius: 5px;
  transition: 0.3s;
}

.sidebar a:hover {
  background-color: rgb(63, 125, 206);
}

.navbar {
  margin-left: 250px;
  background: linear-gradient(135deg, #2a5298, #1e3c72);
  padding: 15px;
  color: white;
  display: flex;
  align-items: center;
  justify-content: center;
  position: fixed;
  top: 0;
  z-index: 1000;
  width: calc(100% - 250px);
}

.content {
  margin-top: 70px;
  margin-left: 255px;
  padding: 20px;
  width: 100%;
  text-align: center;
  height: 90%;
}

footer {
  background: linear-gradient(135deg, #2a5298, #1e3c72);
  color: white;
  padding: 10px 0;
  position: fixed;
  bottom: 0;
  left: 250px;
  width: calc(100% - 250px);
  text-align: center;
  z-index: 999;
}

@media (max-width: 768px) {
  .sidebar {
    width: 200px;
  }

  .navbar,
  footer {
    width: calc(100% - 200px);
  }
}
</style>

<body>

  <!-- Sidebar -->
  <div class="sidebar">
    <img src="{{ asset('images/atjoin_logo.png') }}" alt="Company Logo">
    <h3>Dashboard</h3>
    <a href="{{ route('home.index') }}">🏠 Home</a>
    <a href="{{route('quotationlist.index')}}">📜 Quotation List</a>
    <a href="{{ route('customer') }}" class="text-white">
      <i class="fas fa-user"></i> Customer Master
    </a>


  </div>

  <!-- Navbar -->
  <div class="navbar">
    <h4>Existing Customer</h4>
  </div>

  <!-- Main Content -->
  <div class="content">
    <form id="existingCustomerForm" action="{{ route('customer.save') }}" method="POST">
      @csrf
      <div class="container">
        <div class="row">
          <div class="col-md-2">
            <label for="customer-select"><strong>Choose Customer:</strong></label>
          </div>
          <div class="col-md-6">
            <select id="customer-select" name="customer_id" class="form-select" required>
              <option value="">Select Customer</option>

              @foreach($customers as $customer)
              <option value="{{ $customer->id }}" data-details="{{ json_encode($customer) }}">
                {{ $customer->company_name }} {{ $customer->customer_name }}
              </option>
              @endforeach
            </select>

            <div class="invalid-feedback">Please select a customer before proceeding.</div>

            <!-- Customer Details -->
            <div id="customer-details" class="mt-3 p-3 border rounded" style="display: none;">
              <p><strong>Company Name:</strong> <span id="comp-name"></span></p>
              <p><strong>Customer Name:</strong> <span id="cust-name"></span></p>
              <p><strong>Contact:</strong> <span id="cust-contact"></span></p>
              <p><strong>GST Number:</strong> <span id="cust-gst"></span></p>
              <p><strong>Email:</strong> <span id="cust-email"></span></p>
              <p><strong>Address:</strong> <span id="cust-address"></span></p>
              <p><strong>City:</strong> <span id="cust-city"></span></p>
            </div>
          </div>
          <div class="col-md-4">
            <button type="submit" class="btn btn-primary">
              <i class="bi bi-arrow-right-circle-fill me-1"></i>Proceed
            </button>
            <button class="btn btn-primary ms-3" data-bs-toggle="modal" data-bs-target="#addCustomerModal"
              type="button">
              <i class="bi bi-person-plus-fill me-1"></i>Add New Customer
            </button>
          </div>
        </div>
      </div>
    </form>

    <!-- Add Customer Modal -->
    <div class="modal fade" id="addCustomerModal" tabindex="-1" aria-labelledby="addCustomerModalLabel"
      aria-hidden="true">
      <div class="modal-dialog">
        <div class="modal-content">
          <form action="{{ route('home.store') }}" method="POST" id="customerForm" novalidate>
            @csrf
            <div class="modal-header">
              <h5 class="modal-title" id="addCustomerModalLabel">Add New Customer</h5>
              <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
              <div class="mb-3">
                <label class="form-label">Company Name:</label>
                <input type="text" name="company_name" class="form-control">
              </div>
              <div class="mb-3">
                <label class="form-label">Customer Name:</label>
                <input type="text" name="customer_name" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Contact:</label>
                <input type="text" name="contact" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">GST Number:</label>
                <input type="text" name="gst_no" class="form-control">
              </div>
              <div class="mb-3">
                <label class="form-label">Email:</label>
                <input type="email" name="email" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Address:</label>
                <textarea name="address" class="form-control" required></textarea>
              </div>
              <div class="mb-3">
                <label class="form-label">City:</label>
                <input type="text" name="city" class="form-control" required>
              </div>
            </div>
            <div class="modal-footer">
              <button type="submit" class="btn btn-success">Save Customer</button>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>

  <!-- Footer -->
  <footer>
    <div class="container">
      <small>&copy; 2025 ATJOIN PVT LTD. All rights reserved.</small>
    </div>
  </footer>

  <!-- Scripts -->
  <script>
  document.getElementById('existingCustomerForm').addEventListener('submit', function(e) {
    let customerSelect = document.getElementById('customer-select');
    let selectedValue = customerSelect.value;
    let feedback = customerSelect.nextElementSibling; // the .invalid-feedback element

    if (!selectedValue) {
      e.preventDefault(); // stop form from submitting
      customerSelect.classList.add('is-invalid'); // Bootstrap red border
      feedback.style.display = 'block'; // show the validation message
    } else {
      customerSelect.classList.remove('is-invalid');
      feedback.style.display = 'none';
    }
  });

  document.getElementById('customer-select').addEventListener('change', function() {
    let selectedOption = this.options[this.selectedIndex];
    let customerDetails = selectedOption.dataset.details ? JSON.parse(selectedOption.dataset.details) : null;

    if (customerDetails) {
      document.getElementById('comp-name').innerText = customerDetails.company_name;
      document.getElementById('cust-name').innerText = customerDetails.customer_name;
      document.getElementById('cust-contact').innerText = customerDetails.contact;
      document.getElementById('cust-gst').innerText = customerDetails.gst_no;
      document.getElementById('cust-email').innerText = customerDetails.email;
      document.getElementById('cust-address').innerText = customerDetails.address;
      document.getElementById('cust-city').innerText = customerDetails.city;
      document.getElementById('customer-details').style.display = 'block';
    } else {
      document.getElementById('customer-details').style.display = 'none';
    }
  });

  document.addEventListener("DOMContentLoaded", function() {
    let customerNameInput = document.querySelector('input[name="customer_name"]');
    let contactInput = document.querySelector('input[name="contact"]');

    customerNameInput.addEventListener("input", function() {
      let value = customerNameInput.value;
      customerNameInput.value = value.replace(/\b\w/g, char => char.toUpperCase());
    });

    contactInput.addEventListener("input", function() {
      contactInput.value = contactInput.value.replace(/\D/g, "").slice(0, 10);
    });
  });

  (() => {
    'use strict';
    const form = document.getElementById('customerForm');
    form.addEventListener('submit', function(event) {
      if (!form.checkValidity()) {
        event.preventDefault();
        event.stopPropagation();
      }
      form.classList.add('was-validated');
    }, false);
  })();
  </script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

</body>

</html>