<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Dashboard</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

  <style>
  body {
    background-color: #f4f6f9;
    display: flex;
    height: 100vh;
    font-family: 'Arial', sans-serif;
  }

  /* Sidebar */
  .sidebar {
    width: 250px;
    background: linear-gradient(135deg, #2c3e50, #2a5298);
    padding: 20px;
    color: white;
    height: 100%;
    position: fixed;
    left: 0;
    top: 0;
  }

  .sidebar img {
    width: 120px;
    height: auto;
    margin-bottom: 20px;
    border-radius: 10px;
  }

  .sidebar a {
    display: block;
    color: white;
    text-decoration: none;
    padding: 12px;
    margin: 10px 0;
    border-radius: 5px;
    transition: 0.3s;
    font-size: 16px;
  }

  .sidebar a:hover {
    background-color: rgba(255, 255, 255, 0.2);
  }

  .logout-btn {
    background-color: #dc3545;
    color: white;
    font-weight: bold;
    padding: 12px;
    text-align: center;
    border-radius: 5px;
    text-decoration: none;
    display: block;
  }

  .logout-btn:hover {
    background-color: #c82333;
  }

  /* Navbar */
  .navbar {
    width: calc(100% - 250px);
    margin-left: 250px;
    background: linear-gradient(135deg, #2a5298, #1e3c72);
    padding: 15px;
    color: white;
    display: flex;

    justify-content: space-between;
    align-items: center;
    position: fixed;
    top: 0;
    z-index: 1000;
  }

  .user-info {
    font-size: 16px;
    font-weight: bold;
  }

  /* Content Section */
  .content {
    margin-left: 270px;
    padding: 20px;
    width: 100%;
    text-align: center;
    margin-top: 70px;
  }

  .dashboard-title {
    font-size: 28px;
    font-weight: bold;
    margin-bottom: 20px;
    color: #333;
  }

  /* Cards */
  .card {
    border: none;
    border-radius: 12px;
    transition: all 0.3s ease;
    box-shadow: 0 5px 10px rgba(0, 0, 0, 0.1);
    background: linear-gradient(to right, #ff9966, #ff5e62);
    color: white;
  }

  .card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 20px rgba(0, 0, 0, 0.2);
  }

  .card-header {
    font-size: 20px;
    font-weight: bold;
    text-align: center;
    background: rgba(255, 255, 255, 0.2);
    padding: 15px;
    border-radius: 12px 12px 0 0;
  }

  .card-body {
    padding: 30px;
    text-align: center;
  }

  .card-count {
    font-size: 24px;
    font-weight: bold;
    padding: 10px;
  }

  .customer-link {
    color: inherit;
    /* Keeps text color default */
    text-decoration: none;
    /* Removes underline */
  }

  .customer-link .icon {
    color: white;
    /* Only the icon will be white */
  }

  /* Responsive Design */
  @media (max-width: 768px) {
    .sidebar {
      width: 200px;
    }

    .navbar {
      width: calc(100% - 200px);
      margin-left: 200px;
    }

    .content {
      margin-left: 200px;
    }
  }
  </style>
</head>

<body>

  <!-- Sidebar -->
  <div class="sidebar">
    <img src="{{ asset('images/atjoin_logo.png') }}" alt="Company Logo">
    <h3>Dashboard</h3>
    <a href="{{ route('home.index') }}">🏠 Home</a>
    <a href="{{route('quotationlist.index')}}">📜 Quotation List</a>
    <a href="{{ route('customer') }}" class="text-white">
      <i class="fas fa-user"></i> Customer Master
    </a>

  </div>

  <!-- Navbar -->
  <div class="navbar">
    <h4>Dashboard</h4>

    <a href="{{ route('logout') }}" class="logout-btn" title="Logout">
      <i class="fas fa-sign-out-alt"></i> <!-- Font Awesome Logout Icon -->
    </a>
  </div>

  <!-- Content -->
  <div class="content">
    <h2 class="dashboard-title">Welcome to Your Dashboard</h2>

    <div class="row justify-content-center">
      <div class="col-md-4">
        <div class="card">
          <div class="card-header"><i class="fas fa-users fa-lg me-2"></i>Total Customers</div>
          <div class="card-body">
            <h3 class="card-count">{{ $customerCount }}</h3>
          </div>
        </div>
      </div>
    </div>

</body>

</html>