<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Quotation;
use App\Models\Invoice;
use App\Models\QuotationItem;
use App\Models\InvoiceItem;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Barryvdh\DomPDF\Facade\Pdf;

class InvoiceController extends Controller
{
    public function index() {
       
        return view('quotationlist.invoice');
    }

    
    public function showInvoice( $id)
{
    $quotation = Quotation::with('items')->findOrFail($id);
    $quotationitems = QuotationItem::where('quotation_id', $id)->get();

    // Generate Invoice Number
    $latestInvoice = Invoice::latest()->first();
    // Generate the new invoice number
 $latestInvoice = Invoice::where('invoice_number', 'like', 'AIN-' . now()->format('ym') . '-%')
 ->orderBy('id', 'desc')
 ->first();

if ($latestInvoice) {
 $lastNumber = (int) substr($latestInvoice->invoice_number, -5);
 $newNumber = str_pad($lastNumber + 1, 5, '0', STR_PAD_LEFT);
} else {
 $newNumber = '00001'; // Start from 00001 if no previous quotations exist
}

$invoiceNumber = 'AIN-' . now()->format('ym') . '-' . $newNumber;

    $invoiceDate =  now()->format('Y-m-d');

  

    return view('quotationlist.invoice', compact('quotation', 'quotationitems', 'invoiceNumber','invoiceDate'));
}


public function createInvoice($quotationId) {
    $quotation = Quotation::findOrFail($quotationId);
    $quotationitems = QuotationItem::where('quotation_id', $quotationId)->get();
    $latestInvoice = Invoice::latest()->first();
  

    ////////////////////////////////////////////////

 // Generate the new invoice number
 $latestInvoice = Invoice::where('invoice_number', 'like', 'AIN-' . now()->format('ym') . '-%')
 ->orderBy('id', 'desc')
 ->first();

if ($latestInvoice) {
 $lastNumber = (int) substr($latestInvoice->invoice_number, -5);
 $newNumber = str_pad($lastNumber + 1, 5, '0', STR_PAD_LEFT);
} else {
 $newNumber = '00001'; // Start from 00001 if no previous quotations exist
}

$invoiceNumber = 'AIN-' . now()->format('ym') . '-' . $newNumber;

    ///////////////////////////////////////////////////



    return view('quotationlist.invoice', compact('quotation', 'quotationitems', 'invoiceNumber'));
}

public function storeInvoice(Request $request, $quotationId)
{
    $validated = $request->validate([
        
            'discount' => 'required|numeric',
            'balance_due' => 'required|numeric',
    ]);
    
    $quotation = Quotation::findOrFail($quotationId);
    $quotationitems = QuotationItem::where('quotation_id', $quotationId)->get();
    
    $latestInvoice = Invoice::latest()->first();
   // Generate the new invoice number
 $latestInvoice = Invoice::where('invoice_number', 'like', 'AIN-' . now()->format('ym') . '-%')
 ->orderBy('id', 'desc')
 ->first();

if ($latestInvoice) {
 $lastNumber = (int) substr($latestInvoice->invoice_number, -5);
 $newNumber = str_pad($lastNumber + 1, 5, '0', STR_PAD_LEFT);
} else {
 $newNumber = '00001'; // Start from 00001 if no previous quotations exist
}

$invoiceNumber = 'AIN-' . now()->format('ym') . '-' . $newNumber;
    
 // Create new invoice
 $invoice = Invoice::create([
    'invoice_number' => $invoiceNumber,
    'invoice_date' => now()->format('Y-m-d'),
    'company_name' => $quotation->company_name,
    'customer_name' => $quotation->customer_name,
    'address' => $quotation->address,
    'contact' => $quotation->contact,
    'email' => $quotation->email,
    'gst_number' => $quotation->gst_number,
    'subtotal' => $quotation->subtotal,
    'discount' => $validated['discount'],
    'balance_due' => $validated['balance_due'],
]);

 // Store Invoice Items
 foreach ($quotationitems as $item) {
    InvoiceItem::create([
        'invoice_id' => $invoice->id,
        'description' => $item->description,
        'quantity' => $item->quantity,
        'amount' => $item->amount,
        'total_amount' => $item->total_amount,
    ]);
}
    
    return redirect()->route('pdf.invoice', ['id' => $invoice->id])
    ->with('success', 'Invoice generated successfully.');
}





public function showlatestInvoice($id)
{
    $invoice = Invoice::findOrFail($id);
    $quotation = Quotation::with('items')->where('id', $invoice->quotation_id)->first();
    $quotationItems = QuotationItem::where('quotation_id', $quotation->id)->get();

    return redirect()->route('pdf.invoice', compact('quotation', 'quotationItems', 'invoice'));
    
}

public function generatePDF($id)
    {
        // Fetch invoice data from database
        $invoice = Invoice::findOrFail($id);
        $items = InvoiceItem::where('invoice_id', $id)->get();

        // Load PDF view and pass data
        $pdf = PDF::loadView('pdf.invoice', compact('invoice', 'items'));

        // Return generated PDF
        return $pdf->download('invoice_'.$invoice->invoice_no.'.pdf');
    }

}