<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SelectCustomer;
use App\Models\Customer;
class HomeController extends Controller
{
    public function index() {
        $customers = Customer::all(); // Fetch all customers
        $selectedCustomer = SelectCustomer::first(); // Get the selected customer
        return view('home', compact('customers', 'selectedCustomer'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'company_name' => 'nullable|string|max:255',
            'customer_name' => 'required|string|max:255',
            'contact' => 'required|string|max:15',
            'gst_number' => 'nullable|string|max:20',
            'email' => 'required|email|max:255',
            'address' => 'required|string',
            'city' => 'required|string|max:100',
        ]);

        Customer::create($request->all());

        return redirect()->route('home.index')->with('success', 'Customer added successfully!');
    }
    public function saveChosenCustomer(Request $request)
    {
        $request->validate([
            'customer_id' => 'required|exists:customers,id',
        ]);

        $customer = Customer::find($request->customer_id);

         // Delete any previously selected customer
         SelectCustomer::truncate();
        

          // Store the selected customer in `selected_customers` table
          SelectCustomer::create([
            'customer_id' => $customer->id,
            'company_name' => $customer->company_name,
            'customer_name' => $customer->customer_name,
            'contact' => $customer->contact,
            'gst_number' => $customer->gst_number,
            'email' => $customer->email,
            'address' => $customer->address,
            'city' => $customer->city,
        ]);

        return redirect()->route('items')->with('success', 'Customer selected and stored successfully!');
    }
}