<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Session;
use App\Models\User;

class AuthController extends Controller
{
// Show Register Page
public function showRegister()
{
return view('auth.register');
}

// Register User
public function registerUser(Request $request)
{
$request->validate([
'name' => 'required',
'email' => 'required|email|unique:users',
'password' => 'required|min:6'
]);

$user = new User();
$user->name = $request->name;
$user->email = $request->email;
$user->password = Hash::make($request->password);
$user->save();

return redirect()->route('login')->with('success', 'Registration successful. Please login.');
}

// Show Login Page
public function showLogin()
{
return view('auth.login');
}

// Login User
public function loginUser(Request $request)
{
$request->validate([
'email' => 'required|email',
'password' => 'required'
]);

$user = User::where('email', $request->email)->first();

if ($user && Hash::check($request->password, $user->password)) {
Session::put('user', $user);
return redirect('/dashboard');
} else {
return back()->with('error', 'Invalid email or password.');
}
}

  // Show Dashboard
  public function showDashboard()
  {
      if (!Session::has('user')) {
          return redirect()->route('login')->with('error', 'Please log in first.');
      }
      return view('dashboard');
  }

// Logout User
public function logout()
{
Session::forget('user');
return redirect('/login');
}
}