<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use App\Models\Quotation;
use App\Models\Customer;
use App\Models\Item;
use App\Models\Subitem;
use App\Models\QuotationItem;
use Illuminate\Support\Facades\Session;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\SelectCustomer;
use Illuminate\Support\Facades\DB;
use NumberToWords\NumberToWords;
use App\Helpers\NumberToWordHelper;

class QuotationController extends Controller
{   
   

public function index()
{


    return view('quotations.create');
}


    public function show($id)
    {
       
        $quotation = Quotation::latest()->first();
        if (!$quotation) {
            return redirect()->route('quotations.create')->with('error', 'No quotations found. Please create one.');
        }
        
        $selectedCustomer = SelectCustomer::first();
       
        $items = QuotationItem::where('quotation_id', $quotation->id)->get();
        
        
        $latestSubitem = Subitem::where('quotation_id', $id)->first();

       

        if ($latestSubitem) {
            $subtotal = $latestSubitem->subtotal;
            $cgst = $latestSubitem->cgst;
            $sgst = $latestSubitem->sgst;
            $igst = $latestSubitem->igst;
            $grand_total = $latestSubitem->grand_total;
            $gst_rate =$latestSubitem->gst_rate; 
        $gst_type =$latestSubitem->gst_type; 
        } 
        
        
        return view('quotations.create',compact('quotation','selectedCustomer', 'items','subtotal','cgst','sgst','igst','grand_total','latestSubitem','gst_rate','gst_type'));
    }
    
    public function create(Request $request)
    {
       

       
         
    $quotationDate = Carbon::now()->format('Y-m-d');
    
        // Fetch the latest quotation number
        $latestQuotation = Quotation::latest()->first();

   // Generate the new quotation number
   $latestQuotation = Quotation::where('quotation_number', 'like', 'AQN-' . now()->format('ym') . '-%')
   ->orderBy('id', 'desc')
   ->first();

if ($latestQuotation) {
   $lastNumber = (int) substr($latestQuotation->quotation_number, -5);
   $newNumber = str_pad($lastNumber + 1, 5, '0', STR_PAD_LEFT);
} else {
   $newNumber = '00001'; // Start from 00001 if no previous quotations exist
}

$quotationNumber = 'AQN-' . now()->format('ym') . '-' . $newNumber;



 

        // Prepare quotation data (if not editing an existing one)
        $quotation = new Quotation([
            'quotation_number' => $quotationNumber,
            'quotation_date' => now()->format('Y-m-d'),
            
        ]);

       
        // $items = QuotationItem::all();
       
// Fetch selected customer
$selectedCustomer = SelectCustomer::first();
         // Retrieve selected rows from session
         $selectedRows = Session::get('selected_rows', []);
         
        
        
        
    $latestSubitem = \App\Models\Subitem::latest()->first();

    if ($latestSubitem) {
        $subtotal = $latestSubitem->subtotal;
        $cgst = $latestSubitem->cgst;
        $sgst = $latestSubitem->sgst;
        $igst = $latestSubitem->igst;
        $grand_total = $latestSubitem->grand_total;
        $gst_rate =$latestSubitem->gst_rate; 
        $gst_type =$latestSubitem->gst_type; 
    } 

    

        return view('quotations.create', compact('quotation','quotationNumber', 'quotationDate','selectedRows', 'subtotal', 'cgst', 'sgst','igst', 'grand_total',  'latestSubitem', 'selectedCustomer','gst_rate','gst_type'));
    }


    public function store(Request $request)
    {
        // dd($request->all());

        $validate = $request->validate([
            'sr_no' => ['required', 'array'],
            'sr_no.*' => ['required', 'integer'],
            'description' => ['required', 'array'],
            'description.*' => ['required', 'string'],
            'quantity' => ['required', 'array'],
            'quantity.*' => ['required', 'numeric'],
            'amount' => ['required', 'array'],
            'amount.*' => ['required', 'numeric'],
            'total_amount' => ['required', 'array'],
            'total_amount.*' => ['required', 'numeric'],
            'hsn_number' => ['required', 'integer'],

        ]);
        
        $quotation = Quotation::find($request->quotation_id);
        $selectedCustomer = SelectCustomer::first();
       
        $latestSubitem = \App\Models\Subitem::latest()->first();

        if ($latestSubitem) {
            $subtotal = $latestSubitem->subtotal;
            $cgst = $latestSubitem->cgst;
            $sgst = $latestSubitem->sgst;
            $grand_total = $latestSubitem->grand_total;
            $gst_rate =$latestSubitem->gst_rate; 
            $gst_type =$latestSubitem->gst_type; 
        } 
        $quotationDate =  now()->format('Y-m-d');

        $latestQuotation = Quotation::latest()->first();
        
// Generate the new quotation number
$latestQuotation = Quotation::where('quotation_number', 'like', 'AQN-' . now()->format('ym') . '-%')
->orderBy('id', 'desc')
->first();

if ($latestQuotation) {
$lastNumber = (int) substr($latestQuotation->quotation_number, -5);
$newNumber = str_pad($lastNumber + 1, 5, '0', STR_PAD_LEFT);
} else {
$newNumber = '00001'; // Start from 00001 if no previous quotations exist
}

$quotationNumber = 'AQN-' . now()->format('ym') . '-' . $newNumber;



        
          $quotation = Quotation::create([
            'quotation_number' => $quotationNumber,
            'quotation_date' => $quotationDate,
    'company_name' => $selectedCustomer->company_name,
    'customer_name' => $selectedCustomer->customer_name,
    'contact' => $selectedCustomer->contact,
    'gst_number' => $selectedCustomer->gst_number,
    'email' => $selectedCustomer->email,
    'address' => $selectedCustomer->address,
    'city' => $selectedCustomer->city,
    'state' => $selectedCustomer->state,
    'subtotal' => $latestSubitem->subtotal,
    'cgst' => $latestSubitem->cgst,
    'sgst' => $latestSubitem->sgst,
    'igst' => $latestSubitem->igst,
    'grand_total' => $latestSubitem->grand_total,
    'gst_rate' => $latestSubitem->gst_rate,
    'gst_type' => $latestSubitem->gst_type,
    'hsn_number' => $request->hsn_number
            
        ]);
      
        
        // Store each quotation item
        foreach ($request->description as $index => $desc) {
            QuotationItem::create([
                'quotation_id' => $quotation->id,
                'sr_no' => $request->sr_no[$index],
                'description' => $desc,
                'quantity' => $request->quantity[$index],
                'amount' => $request->amount[$index],
                'total_amount' => $request->total_amount[$index],
            ]);
        }
        
       
    
    // $quotation= DB::table('quotations')->get();
    return redirect()->route('pdf.quotation')->with('success', 'Quotation saved successfully.');
    
    }

  



    public function showLatestQuotation()
    {
        // Fetch the latest quotation along with its items
        $quotation = Quotation::latest()->with('items')->first();
        $gst_rate = $quotation->gst_rate;
        $cgst = $quotation->cgst;
        $sgst = $quotation->sgst;
        $igst = $quotation->igst;


        if (!$quotation) {
            return back()->with('error', 'No quotations found.');
        }
        //  $latestSubitem = Subitem::latest()->first();
        // $latestSubitem  = QuotationItem::where('quotation_id', $id)->get();
    $quotation->grand_total_in_words = $this->convertToIndianWords($quotation->grand_total);

        return view('pdf.quotation', compact('quotation', 'gst_rate', 'cgst', 'sgst', 'igst' ));
    }

    public function generatePdf($id)
{
    $quotation = Quotation::with('items')->findOrFail($id);
    
    if (!$quotation) {
        return redirect()->route('quotations.create')->with('error', 'Quotation not found.');
    }
    $gst_rate = $quotation->gst_rate;
        $cgst = $quotation->cgst;
        $sgst = $quotation->sgst;
        $igst = $quotation->igst;
    // $latestSubitem = Subitem::latest()->first();
    $latestSubitem  = QuotationItem::where('quotation_id', $id)->get();
    $quotation->grand_total_in_words = $this->convertToIndianWords($quotation->grand_total);

    $pdf = Pdf::loadView('pdf.quotation', compact('quotation','latestSubitem', 'gst_rate', 'cgst', 'sgst', 'igst'));

    return $pdf->download('quotation-' . $quotation->quotationNumber . '.pdf');
}

public function pdfGenerate($id)
{
    // Fetch the quotation with related items
    $quotation = Quotation::with('items')->findOrFail($id);

    $gst_rate = $quotation->gst_rate;
        $cgst = $quotation->cgst;
        $sgst = $quotation->sgst;
        $igst = $quotation->igst;
    // Check if quotation exists
    if (!$quotation) {
        return redirect()->route('quotations.create')->with('error', 'Quotation not found.');
    }

    // Fetch related quotation items
    $latestSubitem = QuotationItem::where('quotation_id', $id)->get();

    // Convert grand total to words
    $quotation->grand_total_in_words = $this->convertToIndianWords($quotation->grand_total);

    // Load view and generate PDF
    $pdf = Pdf::loadView('pdf.quotationpdf', compact('quotation', 'latestSubitem','gst_rate', 'cgst', 'sgst', 'igst'))
    ->setOptions([
        
        'isHtml5ParserEnabled' => true,
        'isPhpEnabled' => true,
        'isRemoteEnable' => true,
        'remote_enabled' => true,

        'dpi' => 96,
        'defaultFont' => 'Arial',
        'margin_top' => 10,
        'margin_right' => 10,
        'margin_bottom' => 10,
        'margin_left' => 10
    ]);

    // Stream PDF for download
    return $pdf->download('quotation.pdf');
}






    public static function convertToIndianWords($number)
    {
        $words = [
            '0' => '', '1' => 'One', '2' => 'Two', '3' => 'Three',
            '4' => 'Four', '5' => 'Five', '6' => 'Six', '7' => 'Seven',
            '8' => 'Eight', '9' => 'Nine', '10' => 'Ten',
            '11' => 'Eleven', '12' => 'Twelve', '13' => 'Thirteen',
            '14' => 'Fourteen', '15' => 'Fifteen', '16' => 'Sixteen',
            '17' => 'Seventeen', '18' => 'Eighteen', '19' => 'Nineteen',
            '20' => 'Twenty', '30' => 'Thirty', '40' => 'Fourty',
            '50' => 'Fifty', '60' => 'Sixty', '70' => 'Seventy',
            '80' => 'Eighty', '90' => 'Ninety'
        ];

        $digits = ['', 'Hundred', 'Thousand', 'Lakh', 'Crore'];
        $number = round($number);
        $str = [];

        $i = 0;
        while ($number > 0) {
            if ($i == 1) {
                $divider = 10;
            } else {
                $divider = 100;
            }

            $numberPart = $number % $divider;
            $number = floor($number / $divider);

            if ($numberPart) {
                $plural = (($counter = count($str)) && $numberPart > 9) ? 's' : null;
                $hundred = ($counter == 1 && $str[0]) ? ' and ' : null;
                if ($numberPart < 21) {
                    $word = $words[$numberPart];
                } else {
                    $word = $words[floor($numberPart / 10) * 10] . " " . $words[$numberPart % 10];
                }

                $str[] = $word . " " . $digits[$i];
            }
            $i++;
        }

        return implode(' ', array_reverse($str));
    }
}