<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SelectCustomer;
use App\Models\Customer;
use Illuminate\Support\Facades\Validator;
class HomeController extends Controller
{
    public function index(Request $request) {

        $search = $request->input('search');
        if($search != ""){
            $customers = Customer::where('company_name', 'like', '%'.$search.'%') ->orWhere('customer_name', 'like', '%' . $search . '%') ->orWhere('contact', 'like', '%' . $search . '%')->get();
        } else {
            $customers = Customer::all();
        }
        

        
        $selectedCustomer = SelectCustomer::first(); // Get the selected customer
        
        return view('home', compact('customers', 'selectedCustomer','search'));
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'company_name' => 'nullable|string|max:255',
            'customer_name' => ['required', 'regex:/^[A-Z][a-zA-Z\s]*$/','unique:customers,customer_name'],
            'contact' => 'required|string|max:10',
            'gst_number' => 'nullable|string',
            'email' => 'required|string|unique:customers,email',
            'address' => 'required|string',
            'city' => 'required|string',
            'state' => 'required|string',

        ]);
    
        // Add custom field comparisons
        $validator->after(function ($validator) use ($request) {
            $companyName = $request->company_name;
            $customerName = $request->customer_name;
            $address = $request->address;
            $city = $request->city;
    
            if ($companyName && $companyName === $customerName) {
                $validator->errors()->add('company_name', 'Company Name and Customer Name should not be the same.');
            }
            if ($customerName === $address) {
                $validator->errors()->add('customer_name', 'Customer Name and Address should not be the same.');
            }
            if ($address === $city) {
                $validator->errors()->add('address', 'Address and City should not be the same.');
            }
            if ($customerName === $city) {
                $validator->errors()->add('customer_name', 'Customer Name and City should not be the same.');
            }
        });
    
        // Stop if validation fails
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }

        Customer::create($request->all());

        

        return redirect()->route('home.index')->with('success', 'Customer added successfully!');
    }
    public function saveChosenCustomer(Request $request)
    {
        $request->validate([
            'customer_id' => 'required|exists:customers,id',
        ]);

        $customer = Customer::find($request->customer_id);

         // Delete any previously selected customer
         SelectCustomer::truncate();
        

          // Store the selected customer in `selected_customers` table
          SelectCustomer::create([
            'customer_id' => $customer->id,
            'company_name' => $customer->company_name,
            'customer_name' => $customer->customer_name,
            'contact' => $customer->contact,
            'gst_number' => $customer->gst_number,
            'email' => $customer->email,
            'address' => $customer->address,
            'city' => $customer->city,
            'state' => $customer->state,
        ]);

        return redirect()->route('items')->with('success', 'Customer selected and stored successfully!');
    }
}